#ifndef GGAFDXCORE_GGAFDXMASSSPRITEMODEL_H_
#define GGAFDXCORE_GGAFDXMASSSPRITEMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/model/GgafDxMassModel.h"

namespace GgafDxCore {

/**
 * GgafDxMassSpriteActorpfNX.
 * @version 1.00
 * @since 2016/02/25
 * @author Masatoshi Tsuge
 */
class GgafDxMassSpriteModel : public GgafDxMassModel {
    friend class GgafDxModelManager;

public:
    struct VERTEX_model : public GgafDxModel::VERTEX_3D_BASE {
        float tu, tv;     // eNX`W
    };
    VERTEX_model* _paVtxBuffer_data_model;
    WORD* _paIndexBuffer_data;

    float _model_width_px;
    float _model_height_px;
    float _model_half_width_px;
    float _model_half_height_px;
    int _row_texture_split;
    int _col_texture_split;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    GgafDxMassSpriteModel(const char* prm_model_name);

    static void createVertexModel(void* prm, GgafDxMassModel::VertexModelInfo* out_info);

    virtual HRESULT draw(GgafDxFigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    /**
     * fXgN^<BR>
     */
    virtual ~GgafDxMassSpriteModel(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXMASSSPRITEMODEL_H_*/
