#ifndef GGAFDXCORE_GGAFDXMODEL_H_
#define GGAFDXCORE_GGAFDXMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include "jp/ggaf/dxcore/util/XFile/framework/Frm_Mesh.h"
#include "jp/ggaf/dxcore/util/XFile/ToolBox/IOModel_X.h"

#include <d3d9.h>
#include <d3dx9.h>
#ifdef __GNUG__
    #undef __in
    #undef __out
#endif

//#define Obj_GgafDxDynaD3DXMeshModel      (0x1U)          //0b 00000000 00000000 00000000 00000001
#define Obj_GgafDxD3DXAniMeshModel       (0x2U)            //0b 00000000 00000000 00000000 00000010
#define Obj_GgafDxD3DXMeshModel          (0x4U)            //0b 00000000 00000000 00000000 00000100
#define Obj_GgafDxSpriteModel            (0x8U)            //0b 00000000 00000000 00000000 00001000
#define Obj_GgafDxSpriteSetModel         (0x10U)           //0b 00000000 00000000 00000000 00010000
#define Obj_GgafDxBoardModel             (0x20U)           //0b 00000000 00000000 00000000 00100000
#define Obj_GgafDxBoardSetModel          (0x40U)           //0b 00000000 00000000 00000000 01000000
#define Obj_GgafDxMeshModel              (0x80U)           //0b 00000000 00000000 00000000 10000000
#define Obj_GgafDxMeshSetModel           (0x100U)          //0b 00000000 00000000 00000001 00000000
#define Obj_GgafDxCubeMapMeshModel       (0x200U)          //0b 00000000 00000000 00000010 00000000
#define Obj_GgafDxCubeMapMeshSetModel    (0x400U)          //0b 00000000 00000000 00000100 00000000
#define Obj_GgafDxMorphMeshModel         (0x800U)          //0b 00000000 00000000 00001000 00000000
#define Obj_GgafDxCubeMapMorphMeshModel  (0x1000U)         //0b 00000000 00000000 00010000 00000000
#define Obj_GgafDxWorldBoundModel        (0x2000U)         //0b 00000000 00000000 00100000 00000000
#define Obj_GgafDxPointSpriteModel       (0x4000U)         //0b 00000000 00000000 01000000 00000000
#define Obj_GgafDxMassModel              (0x8000U)         //0b 00000000 00000000 10000000 00000000
#define Obj_GgafDxMassMeshModel          (0x10000U)        //0b 00000000 00000001 00000000 00000000
#define Obj_GgafDxMassBoardModel         (0x20000U)        //0b 00000000 00000010 00000000 00000000
#define Obj_GgafDxMassSpriteModel        (0x40000U)        //0b 00000000 00000100 00000000 00000000
#define Obj_GgafDxMassMorphMeshModel     (0x80000U)        //0b 00000000 00001000 00000000 00000000
#define Obj_GgafDxMassPointSpriteModel   (0x100000U)       //0b 00000000 00010000 00000000 00000000
#define Obj_GgafDxPointSpriteSetModel    (0x200000U)       //0b 00000000 00100000 00000000 00000000
#define Obj_GgafDxFramedBoardModel     (0x400000U)       //0b 00000000 01000000 00000000 00000000

namespace GgafDxCore {

/**
 * fNX.
 * L(AN^[)̌`FȂǂێNXłB<BR>
 * @version 1.00
 * @since 2008/02/21
 * @author Masatoshi Tsuge
 */
class GgafDxModel : public GgafCore::GgafObject {
    friend class GgafDxModelManager;

public:
    struct VERTEX_3D_BASE {
        float x, y, z;    // _W
        float nx, ny, nz; // @
    };

    /** [r]ő\`ZbgiLN^j*/
    int _set_num;
    /** [r]f`̎ʖB(50܂) */
    char* _model_name;
    /** [r]fCX^X */
    uint32_t _obj_model;

    /** [r]}eAz */
    D3DMATERIAL9* _paMaterial_default;
    /** [r]}eA */
    DWORD _num_materials;
    /** [r]eNX`t@C̔z */
    std::string* _pa_texture_filenames;
    /** [r]eNX`RlNVz */
    GgafDxTextureConnection** _papTextureConnection;


    /** [rw]f̋EaBʊOɗp */
    FLOAT _bounding_sphere_radius;
    /** [r]_ŋx (0.0 <= _power_blink <= 1.0)BGgafDxTextureBlinkerɂ葀삷邱 */
    FLOAT _power_blink;
    /** [r]_őΏRGBl(0.0 <= tex2D()rgb̉ꂩ <= 1.0)BGgafDxTextureBlinkerɂ葀삷邱 */
    FLOAT _blink_threshold;
    //_blink_threshold = 1.0 Ǝw肵ꍇAPStex2D()̃TvOJ[
    //r,g,b ꂩ >= 1.0  ̏ꍇA_power_blink{̐F(rgb)Z
    //[rEX̃L̐Ԃ_ł̂悤ȂƂߍ쐬B


    /** [r]eNX`RlNVz̃ftHg̃CfbNXBʏ0B */
    int _default_texture_index;
    /** [r]_őxIuWFNg */
    GgafDxTextureBlinker* const _pTexBlinker;
    /** [r]GgafDxTextureBlinkerpJE^[ */
    frame _blinker_frames;

    /** [r/w]f̃XyL[͈̔́in[txNgE@ςg_specularj */
    float _specular;
    /** [r/w]f̃XyL[̋xiŜ̔{A0.0ȊOݒ肷ƃXyLLɂȂj */
    float _specular_power;

    /** [r]fPʂ̏sς݂ǂ(draw`FbNύX) */
    bool _is_init_model;

    UINT _num_pass;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name f`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    explicit GgafDxModel(const char* prm_model_name);

    char* getName(){
        return _model_name;
    }

    /**
     * FxƁAΏېFlݒ .
     * ΏېFlƂ́AFxe^Ώۂ̃eNX`̐F̋łB<BR>
     * sNZVF[_[ɂāA<BR>
     * E܂ł̌vZFieNX`⃉Cglς݁jEEE colOut.rgba<BR>
     * EeNX`̐F EEE colTex.rgba<BR>
     * EΏېFl EEE g_tex_blink_threshold<BR>
     * E݂̐Fxl EEE g_tex_blink_power<BR>
     * ƂꍇAȉ̗lȏsȂĂ܂B<BR>
     * <code><pre>
     * <BR>
     * if (colTex.r >= g_tex_blink_threshold || colTex.g >= g_tex_blink_threshold || colTex.b >= g_tex_blink_threshold) {
     *     colOut *= g_tex_blink_power; //ă{|B_łڗB
     * }
     * </pre></code>
     * [rEX̒n㕨̐Ԃ_ł̂悤ȃGtFNgȒPɎ邽߂ɎEE(ɺ
     * @param prm_power_blink Fxl1 (̐ ` 0: ` 1.0:{x ` )
     * @param prm_blink_threshold FxleΏېFl (0.0 ` 1.0)
     */
    void setBlinkPower(float prm_power_blink, float prm_blink_threshold) {
        _power_blink = prm_power_blink;
        _blink_threshold = prm_blink_threshold;
    }

    /**
     * Fxl݂̂ݒ .
     * @param prm_power_blink Fxl1 (̐ ` 0: ` 1.0:{x ` )
     */
    void setBlinkPower(float prm_power_blink) {
        _power_blink = prm_power_blink;
    }
    /**
     * FxfΏۂ̐Flݒ .
     * @param prm_blink_threshold FxleΏېFl (0.0 ` 1.0)
     */
    void setBlinkThreshold(float prm_blink_threshold) {
        _blink_threshold = prm_blink_threshold;
    }
    /**
     * Fxl擾 .
     * @return Fxl
     */
    float getBlinkPower() {
        return _power_blink;
    }

    /**
     * f̃XyL[xݒ .
     * ̈ 0 ȊO̐lݒ肷ƁAXyL[LɂȂ܂B
     * ̂悤ɐݒ肷ƃXyL[𖳌ɏo܂BiftHg̓XyL[𖳌j
     * setSpecular(0, 0)
     * @param prm_specular f̃XyL[͈̔́in[txNgE@ςg_specularj
     * @param prm_specular_power f̃XyL[̋xiŜ̔{A0.0ȊOݒ肷ƃXyLLɂȂj
     */
    virtual void setSpecular(float prm_specular, float prm_specular_power) {
        _specular = prm_specular;
        _specular_power = prm_specular_power;
    }


    inline GgafDxTextureBlinker* getTexBlinker() {
        return _pTexBlinker;
    }

    /**
     * K̃eNX`i}eAԍ0Ԃ̃eNX`) ύXB
     * @param prm_material_no }eAԍĩeNX`ɒuj
     */
    inline void setDefaultTextureMaterialNo(int prm_material_no) {
        _default_texture_index = prm_material_no;
    }

    /**
     * K̃eNX`ւ̃RlNV擾 .
     * @return K̃eNX`
     */
    inline GgafDxTextureConnection* getDefaultTextureConnection() {
        return _papTextureConnection[_default_texture_index];
    }

    /**
     * f` .
     * ʃNXŃf`惍WbNĉB
     * @param prm_pActor_target `悷郂f̃AN^[
     * @param prm_draw_set_num `悷郂f̃Zbg
     * @param prm_pPrm ėpp[^
     * @return
     */
    virtual HRESULT draw(GgafDxFigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) = 0;

    /**
     * }eÃeNX`ւĐ؂ւB .
     * \߃fɕ̃eNX`(}eA)o^ĒuKvB<BR>
     * ̓Iɂ X t@Cŗ\ߕ}eAGgieNX`jĂB<BR>
     * @param prm_texture0 \߃fɕ̃eNX`̐؂ւ̃eNX`ID
     *                    iGgafDxTextureManager ɃGgĂ鎯ʕj
     */
    //virtual void swapTopTextureOrder(const char* prm_texture0);


    /**
     * _obt@ɋʎO{B
     * EXt@C̖@ݒBi@񖳂ꍇ͐Đݒj
     * E@񂩂AڃxNgiTangentjyя]@iBinormaljvZĐݒB
     * EXt@C FrameTransformMatrixϊKp
     * @param prm_paVtxBuffer XV_obt@f[^ix,y,z,tu,tv ͐ݒς݂̑Oj
     * @param prm_size_of_vtx_unit f̂P_f[^̃TCY
     * @param model_pModel3D
     * @param paNumVertices _AO̒_TuZbg̔z
     *        ifTuZbgPʂŌʊiʒuA]AgjێĂꍇj
     */
    void prepareVtx(void* prm_paVtxBuffer, UINT prm_size_of_vtx_unit,
                    Frm::Model3D* model_pModel3D,
                    uint16_t* paNumVertices);

    static void calcTangentAndBinormal(
            D3DXVECTOR3* p0, D3DXVECTOR2* uv0,
            D3DXVECTOR3* p1, D3DXVECTOR2* uv1,
            D3DXVECTOR3* p2, D3DXVECTOR2* uv2,
            D3DXVECTOR3* outTangent, D3DXVECTOR3* outBinormal);


    /**
     * Ԃ3_v0 v1 v2 A v0v1  v1v2 ̐p(pv1)߂
     * @param v0
     * @param v1
     * @param v2
     * @return p(fBA)
     */
    static float getRadv1_v0v1v2(Frm::Vertex& v0, Frm::Vertex& v1, Frm::Vertex& v2);

    void setMaterial(Frm::Mesh* in_pMeshesFront = nullptr);

    /**
     * fč\z܂.
     */
    virtual void restore() = 0;

    /**
     * f܂.
     */
    virtual void release() = 0;

    /**
     * foCXXgR[obN
     */
    virtual void onDeviceLost() = 0;

    /**
     * fXgN^<BR>
     * deletêGgafDxModelManagerł<BR>
     */
    virtual ~GgafDxModel(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXMODEL_H_*/
