#ifndef GGAFDXCORE_GGAFDXSPACETIME_H_
#define GGAFDXCORE_GGAFDXSPACETIME_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/scene/GgafSpacetime.h"

#include "jp/ggaf/dxcore/GgafDxProperties.h"
#include "jp/ggaf/dxcore/actor/camera/GgafDxCamera.h"


#define EX_RENDER_DEPTH_INDEXS_FRONT_NUM   (5)
#define REGULAR_RENDER_DEPTH_INDEXS_NUM    (PROPERTY::RENDER_DEPTH_INDEXS_NUM)  //iK_[\
#define EX_RENDER_DEPTH_INDEXS_BACK_NUM    (5)
#define ALL_RENDER_DEPTH_INDEXS_NUM        (EX_RENDER_DEPTH_INDEXS_FRONT_NUM+REGULAR_RENDER_DEPTH_INDEXS_NUM+EX_RENDER_DEPTH_INDEXS_BACK_NUM)

#define RENDER_DEPTH_INDEX_FRONT      (EX_RENDER_DEPTH_INDEXS_FRONT_NUM)  //ʏ̍őO
#define RENDER_DEPTH_INDEX_BACK       (EX_RENDER_DEPTH_INDEXS_FRONT_NUM + REGULAR_RENDER_DEPTH_INDEXS_NUM - 1) //ʏ̍Ŕw

 /** őOʂO̓ʂȕ\[xx(0`5  0:RENDER_DEPTH_INDEX_FRONTƓA5:őO) */
#define RENDER_DEPTH_INDEX_SP_FRONT(X)  (RENDER_DEPTH_INDEX_FRONT - (X))

 /** őOʂ艜̓ʂȕ\[xx(0`5  0:RENDER_DEPTH_INDEX_BACKƓA5:Ŕw) */
#define RENDER_DEPTH_INDEX_SP_BACK(X)  (RENDER_DEPTH_INDEX_BACK + (X))

namespace GgafDxCore {

/**
 * GgafDxCoreOԂ̂̐NX.
 * GgafDxCoreOԓł́ÃNX̂̐NXƂ܂B<BR>
 * (GgafDxWorldBound)
 * @version 1.00
 * @since 2008/07/30
 * @author Masatoshi Tsuge
 */
class GgafDxSpacetime : public GgafCore::GgafSpacetime {

private:
    /**
     * t[̕`揈 .
     * iK_OsȂ void GgafElement<T>::draw() I[o[ChB<BR>
     * {NX(GgafSpacetime)͒_̃V[ł邽߁Ȃ̃AN^[V[̑SẮA<BR>
     * void GgafElement<T>::draw() Ă΂邱Ƃł傤B<BR>
     */
    virtual void draw() override;

public:
    class SeArray {
    public:
        int _p;
        GgafDxSe* _apSe[64];
        int _volume[64];
        float _pan[64];
        float _frequency_rate[64];
        GgafDxGeometricActor* _apActor[64];
        SeArray();

        void add(GgafDxSe* prm_pSe, int prm_volume, float prm_pan, float prm_frequency_rate, GgafDxGeometricActor* prm_pActor);

        void play(int index);
    };
    GgafCore::GgafLinkedListRing<SeArray>* _pRing_pSeArray;

public:
    /** J */
    GgafDxCamera* _pCamera;

    /** _Ozɓo^ĂeAN^[Xg̐擪̃AN^[̔z */
    GgafDxFigureActor** _papFirstActor_in_render_depth;
    /** _Ozɓo^ĂeAN^[Xg̖̃AN^[̔z */
    GgafDxFigureActor** _papLastActor_in_render_depth;

    /** `AN^[̃J[\ */
    static GgafDxFigureActor* _pActor_draw_active;
    static int render_depth_index_active;
    /** [r]AvP[V̈AXW̍ŏl */
    const coord _x_bound_left;
    /** [r]AvP[V̈AXW̍ől */
    const coord _x_bound_right;
    /** [r]AvP[V̈AYW̍ŏl */
    const coord _y_bound_bottom;
    /** [r]AvP[V̈AYW̍ől */
    const coord _y_bound_top;
    /** [r]AvP[V̈AZW̍ŏl */
    const coord _z_bound_near;
    /** [r]AvP[V̈AZW̍ől */
    const coord _z_bound_far;

    static std::string _seqkey_se_delay;

    /** IuWFNg̃J̉(pixcoord)ɑ΂AiK_OCfbNX̔z */
    int* _paDep2Lv;
    /** iK_OLȃJin_j牜ւ̋ */
    dxcoord _dep_resolution;


public:
    GgafDxSpacetime(const char* prm_name, GgafDxCamera* prm_pCamera);

    virtual void processSettlementBehavior() override;

    virtual ~GgafDxSpacetime();

    virtual GgafDxCamera* getCamera() {
        return _pCamera;
    }

    /**
     * ̐ɃAN^[o^(2DIuWFNgp) .
     * o^ƁA̐ɕ`悳邱ƂƂȂB
     * @param prm_pActor ΏۃAN^[
     * @return o^ꂽ`揇[xx
     */
    int registerFigureActor2D(GgafDxFigureActor* prm_pActor);

    /**
     * ̐ɃAN^[o^(3DIuWFNgp) .
     * o^ƁA̐ɕ`悳邱ƂƂȂB
     * Ȃǔ͂ɓo^AxO֌W\B
     * @param prm_pActor ΏۃAN^[
     * @return o^ꂽ`揇[xx
     */
    int registerFigureActor3D(GgafDxFigureActor* prm_pActor);

    /**
     * ̐ɌʉIuWFNgo^ .
     * o^ƁA̐ɌʉB
     * ɓʉxo^ƁAʒˏオh~̈
     * ɂ΂ĔB
     * @param prm_pSe ʉIuWFNg
     * @param prm_volume {[(0 ` 1000)
     * @param prm_pan    p(left:-1.0 ` center:0 ` right:1.0)
     * @param prm_frequency_rate ̎gɏ悸闦
     * @param prm_delay  xt[
     * @param prm_pActor ʉAN^[
     */
    void registerSe(GgafDxSe* prm_pSe,
                    int prm_volume,
                    float prm_pan,
                    float prm_frequency_rate,
                    int prm_delay,
                    GgafDxGeometricActor* prm_pActor);
};

}
#endif /*GGAFDXCORE_GGAFDXSPACETIME_H_*/
