#ifndef GGAFLIB_LASERCHIP_H_
#define GGAFLIB_LASERCHIP_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/dxcore/actor/GgafDxMassMeshActor.h"

namespace GgafLib {

/**
 * |C[U[̃`bv̊NX .
 * Ӂ
 * processSettlementBehavior()̏ɂA
 * setHitAble(false); ͈ӖȂ܂B
 * 蔻sȂꍇA
 * registerHitAreaCube_AutoGenMidColli() ̓蔻莩̂쐬ȂŉB
 * @version 1.00
 * @since 2008/11/24
 * @author Masatoshi Tsuge
 */
class LaserChip : public GgafDxCore::GgafDxMassMeshActor {
    friend class WateringLaserChip;
    friend class HomingLaserChip;
    friend class RefractionLaserChip;
    friend class StraightLaserChip;
    friend class NomalLaserChip;
    friend class LaserChipDepository;

private:

    /** onAcive() ŃZbgU镑t[ */
    frame _frame_of_behaving_from_onActive;

    /** gǗĂAN^[ */
    LaserChipDepository* _pDepo;
    /** registerHitAreaCube_AutoGenMidColli() \bhɂo^̓蔻藧̂̂Pӂ̒ */
    int _hitarea_edge_length;
    int _hitarea_edge_length_3;
    /** registerHitAreaCube_AutoGenMidColli() \bhɂo^̓蔻藧̂̂Pӂ̒̔ */
//    int _harf_hitarea_edge_length;

    int _hdx,_hdy,_hdz;


    /** Õ[U[`bv */
    LaserChip* _pChip_infront;
    /** ̃[U[`bv */
    LaserChip* _pChip_behind;

public:

    struct VERTEX_instancedata {
        float _11, _12, _13, _14;   // : TEXCOORD1  WorldϊsAPs
        float _21, _22, _23, _24;   // : TEXCOORD2  WorldϊsAQs
        float _31, _32, _33, _34;   // : TEXCOORD3  WorldϊsARs
        float _41, _42, _43, _44;   // : TEXCOORD4  WorldϊsASs

        float _f_11, _f_12, _f_13, _f_14;   // : TEXCOORD5  O`bvWorldϊsAPs
        float _f_21, _f_22, _f_23, _f_24;   // : TEXCOORD6  O`bvWorldϊsAQs
        float _f_31, _f_32, _f_33, _f_34;   // : TEXCOORD7  O`bvWorldϊsARs
        float _f_41, _f_42, _f_43, _f_44;   // : TEXCOORD8  O`bvWorldϊsASs

        float _chip_kind, _force_alpha;   // : TEXCOORD9  `bvʁA
    };

    static VERTEX_instancedata _aInstancedata[];
    CollisionChecker* _pColliChecker;

    /** [U[eNX`  0:s 1: 2: 3:擪QԖڂŐ擪̃eNX` i擪͖Dj 4:{̐擪(A`łȂ) */
    int _chip_kind;
    /** [r]n`qbg`bv(101) */
    bool _can_chikei_hit;
    /** [r]㏑At@lBio͉łĂ\邽) */
    float _force_alpha;
    /** [r]trueȂ΁AO`bvƗꂷꍇɒԓ蔻莩 */
    bool _middle_colli_able;

public:
    LaserChip(const char* prm_name, const char* prm_model, GgafCore::GgafStatus* prm_pStat=nullptr);

    static bool initStatic(LaserChip* prm_pLaserChip);

    virtual void executeHitChk_MeAnd(GgafActor* prm_pOtherActor) override;

    virtual void onActive() override;
    /**
     * lXȎO .
     * Ӂ
     * setHitAble(true);
     * ŎsĂ܂̂ŁA
     * setHitAble(false);
     * ͖ӖłB
     */
    virtual void processSettlementBehavior() override;

    virtual void processPreDraw() override;
    virtual void processDraw() override;

    virtual void onInactive() override;

    virtual void drawHitArea() override;

    /**
     * [U[`bvp蔻藧̂Zbg .
     * [U[`bvԂ̋A蔻̂蔲h~邽߁A<BR>
     * ʏ̓蔻ɉAڑꂽO`bvƂ̋ꂽꍇɂ̂݁A<BR>
     * IɒԂɓ蔻@\t^B<BR>
     * 蔻vf͂QɂȂB
     * yӁz<BR>
     * \߃[U[`bvԂ̋JA蔲NȂƂ킩Ăꍇ́A<BR>
     * {\bhŐݒ肹Aʏ getCollisionChecker()->createCollisionArea(1);<BR>
     * sقptH[}XǂB<BR>
     * @param prm_edge_length
     */
    virtual void registerHitAreaCube_AutoGenMidColli(int prm_edge_length);

    inline CollisionChecker* getCollisionChecker() {
        return _pColliChecker;
    }

    /**
     * g̈Õ[U[`bv擾 .
     * 擾łꍇ́AgƘAĂ邱ƂƂȂB
     * 擾łȂꍇ(߂l=nullptr)Ag͐擪`bvłB
     * @return Õ[U[`bvA nullptr
     */
    inline LaserChip* getInfrontChip() {
        return _pChip_infront;
    }

    /**
     * g̈̃[U[`bv擾 .
     * 擾łꍇ́AgƘAĂ邱ƂƂȂB
     * 擾łȂꍇ(߂l=nullptr)Ag͖`bvłB
     * @return ̃[U[`bvA nullptr
     */
    inline LaserChip* getBehindChip() {
        return _pChip_behind;
    }

    static void createVertexInstanceData(void* prm, GgafDxCore::GgafDxMassMeshModel::VertexInstanceDataInfo* out_info);

    virtual ~LaserChip();

};

}
#endif /*GGAFLIB_LASERCHIP_H_*/

