#ifndef GGAFLIB_DEFAULTSPACETIME_H_
#define GGAFLIB_DEFAULTSPACETIME_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/dxcore/scene/GgafDxSpacetime.h"

#include "jp/ggaf/lib/GgafLibProperties.h"
#include "jp/ggaf/core/util/GgafLinearTreeRounder.hpp"
#include "jp/ggaf/lib/actor/camera/DefaultCamera.h"

namespace GgafLib {

/**
 * u̐vNXC^[tFCX.
 * GgafDxCore::GgafDxSpacetime p̃C^[tF[XłB<BR>
 * GgafCu𗘗pꍇA{NXp̐NXKvłB<BR>
 * (DefaultWorld)
 * @version 1.00
 * @since 2008/07/30
 * @author Masatoshi Tsuge
 */
class DefaultSpacetime : public GgafDxCore::GgafDxSpacetime {
    virtual void processFinal() override;

public:
    GgafCore::GgafLinearOctree* _pLinearOctree;
    GgafCore::GgafLinearTreeRounder<GgafCore::GgafActor, 3>* _pLinearOctreeHitCheckRounder;
    GgafCore::GgafLinearQuadtree* _pLinearQuadtree;
    GgafCore::GgafLinearTreeRounder<GgafCore::GgafActor, 2>* _pLinearQuadtreeHitCheckRounder;
public:
    DefaultSpacetime(const char* prm_name, DefaultCamera* prm_pCamera);

    inline GgafCore::GgafLinearOctree* getLinearOctree() {
#ifdef MY_DEBUG
        if (_pLinearOctree == nullptr) {
            throwGgafCriticalException("DefaultSpacetime::getLinearOctree() ؂͍쐬Ă܂B IS_HIT_CHECK_3D vpeB true ɂĂB݂IS_HIT_CHECK_3D="<<PROPERTY::IS_HIT_CHECK_3D );
        }
#endif
        return _pLinearOctree;
    }

    inline GgafCore::GgafLinearTreeRounder<GgafCore::GgafActor, 3>* getLinearOctreeHitCheckRounder() {
#ifdef MY_DEBUG
        if (_pLinearOctreeHitCheckRounder == nullptr) {
            throwGgafCriticalException("DefaultSpacetime::getLinearOctreeHitCheckRounder() ؂͍쐬Ă܂B IS_HIT_CHECK_3D vpeB true ɂĂB݂IS_HIT_CHECK_3D="<<PROPERTY::IS_HIT_CHECK_3D );
        }
#endif
        return _pLinearOctreeHitCheckRounder;
    }

    inline GgafCore::GgafLinearQuadtree* getLinearQuadtree() {
#ifdef MY_DEBUG
        if (_pLinearQuadtree == nullptr) {
            throwGgafCriticalException("DefaultSpacetime::getLinearQuadtree() l؂͍쐬Ă܂B IS_HIT_CHECK_2D vpeB true ɂĂB݂IS_HIT_CHECK_2D="<<PROPERTY::IS_HIT_CHECK_2D );
        }
#endif
        return _pLinearQuadtree;
    }

    inline GgafCore::GgafLinearTreeRounder<GgafCore::GgafActor, 2>* getLinearQuadtreeHitCheckRounder() {
#ifdef MY_DEBUG
        if (_pLinearQuadtreeHitCheckRounder == nullptr) {
            throwGgafCriticalException("DefaultSpacetime::_pLinearQuadtreeHitCheckRounder() l؂͍쐬Ă܂B IS_HIT_CHECK_2D vpeB true ɂĂB݂IS_HIT_CHECK_2D="<<PROPERTY::IS_HIT_CHECK_2D );
        }
#endif
        return _pLinearQuadtreeHitCheckRounder;
    }
    virtual DefaultCamera* getCamera() override { //ς̖߂l
        return (DefaultCamera*)_pCamera;
    }

    virtual ~DefaultSpacetime();
};

}
#endif /*GGAFLIB_DEFAULTSPACETIME_H_*/
