#ifndef MYBUNSHINCONTROLLER_H_
#define MYBUNSHINCONTROLLER_H_
#include "VioletVreath.h"

#include "jp/ggaf/lib/actor/DefaultGeometricActor.h"
#include "jp/ggaf/dxcore/util/GgafDxGeoElem.h"

namespace VioletVreath {

/**
 * gy .
 * @version 1.00
 * @since 2015/04/17
 * @author Masatoshi Tsuge
 */
class MyBunshinBase : public GgafLib::DefaultGeometricActor {

private:
    class Pos {
    public:
        coord x, y, z;
        Pos() : x(0), y(0), z(0) {}
        void set(coord prm_x, coord prm_y, coord prm_z) {
            x = prm_x;   y = prm_y;   z = prm_z;
        }
        void set(const GgafDxCore::GgafDxGeometricActor* p) {
            x = p->_x;   y = p->_y;   z = p->_z;
        }
        void add(coord prm_x, coord prm_y, coord prm_z) {
            x += prm_x;  y += prm_y;  z += prm_z;
        }
    };
    class PosTrace {
    public:
        Pos* _paPos;
        int _num;
        int _p;
        PosTrace(int n) {
            _p = 0;
            _num = n;
            _paPos = NEW Pos[_num];
        }
        /**
         * Jgvfi߁Ai߂Pos𓾂 .
         * @return
         */
        Pos* next() {
            if (_p == _num-1) {
                _p = 0;
            } else {
                _p++;
            }
            return &(_paPos[_p]);
        }
        Pos* getPrev() {
            return &(_paPos[ (_p == 0 ? _num-1 : _p-1) ]);
        }
        Pos* getNext() {
            return &(_paPos[ (_p == _num-1 ? 0 : _p+1) ]);
        }
        Pos* get2Next() {
            return &(_paPos[ (_p == _num-1 ? 1 : (_p == _num-2 ? 0 : _p+2) ) ]);
        }
        ~PosTrace() {
            GGAF_DELETEARR(_paPos);
        }
    };
    inline void setPositionAt(Pos *pPos) {
         setPosition(pPos->x, pPos->y, pPos->z);
    }

    /** [r]g̏㉺͎y]xNgXvf */
    float c_ax_x_;
    /** [r]g̏㉺͎y]xNgYvf */
    float c_ax_y_;
    /** [r]g̏㉺͎y]xNgZvf */
    float c_ax_z_;
    /**
     * {̂̎] .
     * ]px MyBunshinBase::ANGVELO_TURN
     * @param prm_ax_x ]xNgXvf
     * @param prm_ax_y ]xNgYvf
     * @param prm_ax_z ]xNgZvf
     */
    void addTurnAngleAroundAx1(float prm_ax_x, float prm_ax_y, float prm_ax_z);

    /**
     * {̂̎] .
     * ]px MyBunshinBase::ANGVELO_TURN
     * VB_UP,VB_DOWN ̕g̉]xNg(c_ax_x_, c_ax_y_, c_ax_z_) AꏏɎ]B
     * @param prm_ax_x ]xNgXvf
     * @param prm_ax_y ]xNgYvf
     * @param prm_ax_z ]xNgZvf
     */
    void addTurnAngleAroundAx2(float prm_ax_x, float prm_ax_y, float prm_ax_z);

public:
    enum {
        TRACE_TWINBEE,   //cCr[̕ĝ悤ȃg[X
        TRACE_GRADIUS,   //OfBEX̃IvV̂悤ȃg[X
        TRACE_FREEZE,    //OfBEXVType1̃IvVt[Ŷ悤ȓ
    };

    enum {
        PROG_INIT,
        PROG_BUNSHIN_NOMAL_TRACE,
        PROG_BUNSHIN_FREE_MODE_IGNITED,
        PROG_BUNSHIN_FREE_MODE_READY,
        PROG_BUNSHIN_FREE_MODE_MOVE,
        PROG_BUNSHIN_FREE_MODE_STOP,
        PROG_BUNSHIN_FREE_MODE_BACK_TO_DEFAULT_POS,
        PROG_BANPEI,
    };

    /** ő啪g */
    static const int MAX_BUNSHIN_NUM;
    /** [r]gƕg̊Ԋu */
    static const frame BUNSHIN_D;
    /** [r]ǧ̊px */
    static const angvelo ANGVELO_TURN;
    /** [r]g̍L]px */
    static const angvelo ANGVELO_EXPANSE;
    /** [r]g߂Ă鎞MAX */
    static const int RENGE;
    /** gt[ړ̕g̈ړx */
    static const velo VELO_BUNSHIN_FREE_MV;

    static int now_bunshin_num_;


    /** [r]g{ */
    MyBunshin* pBunshin_;
    /** gp̃g[XW̗ji΍WjBJg@WB */
    PosTrace* pPosTrace_;
    /** @g[X̍W̃ItZbg(t[łȂꍇ0) */
    GgafDxCore::GgafDxGeoElem trace_offset_;
    /** gԍ(1`) */
    unsigned int no_;
    /** gԍ1`MAXɂāAo鉉ô߂̏悸銄 */
    double delay_r_;
    /** [r]g𒆐SƂAg̔äʒu(l) */
    coord bunshin_default_radius_pos_;
    /** [r]g𒆐SƂAǧ]Öʒu(l) */
    angle bunshin_default_ang_pos_;
    /** [r]g̍Lpx(l) */
    angle bunshin_default_expanse_;
    /** [r]g𒆐SƂAǧ]̊px(l) */
    angvelo bunshin_default_angvelo_mv_;
    /** [r]gʒu̍Lړx */
    velo bunshin_velo_mv_radius_pos_;
    /** [r]g𒆐SƂAg̔äʒu(W) */
    velo bunshin_radius_pos_;

    /** [r]sړx */
    GgafDxCore::GgafDxAxesMover* pAxsMver_;

    /** [r]̃t[ȏAňړƁATRACE_TWINBEETRACE_GRADIUS Ɉڍs */
    frame moving_frames_since_default_pos_;
    /** [r]݂̃g[X[h */
    int trace_mode_;
    /** gZbgŌ̈ʒuɖ߂Ƃɔ₷̎(t[) */
    frame return_default_pos_frames_;

    /** t[[h true */
    bool is_free_mode_;
    /** [hi@ČǗj true */
    bool is_isolate_mode_;

public:
    /**
     * RXgN^ .
     * @param prm_name
     * @param prm_no gԍ (1`)
     */
    MyBunshinBase(const char* prm_name, unsigned int prm_no);

    /**
     * g̐ݒ .
     * new ɎsĂB
     * @param prm_radius_pos g̈ʒuBS̋iajݒB
     * @param prm_ang_pos    g̈ʒuBǂ̊px̏ꏊʒuƂ邩ݒB
     * @param prm_expanse         g̊OɍLpxB
     * @param prm_angvelo_mv      g̒ʏ펞̎Öړx
     */
    void config(
            coord prm_radius_pos,
            angle prm_ang_pos,
            angle prm_expanse,
            angvelo prm_angvelo_mv);

    virtual void initialize() override;

    virtual void onReset() override;

    virtual void onActive() override;

    virtual void onInactive() override;

    virtual void processBehavior() override;

    virtual void processJudgement() override {}

//DefaultMeshActorŕ\ꍇ̓Rgɂ邱
//GgafDxGeometricActoȑꍇ̓RgO
    //virtual void processDraw() override {}

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {}

    virtual void onHit(const GgafCore::GgafActor* prm_pOtherActor) override {}

    virtual ~MyBunshinBase();

    void resetBunshin(int prm_mode);



    /**
     * gݒ .
     * @param prm_num g̐
     */
    static void setBunshinNum(int prm_num);


};

}
#endif /*MYBUNSHINCONTROLLER_H_*/

