#include "VreathMagic.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/effect/EffectVreathMagic001.h"
#include "jp/gecchi/VioletVreath/actor/my/MyShip.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

VreathMagic::VreathMagic(const char* prm_name, int* prm_pMP)
    : Magic(prm_name, prm_pMP,
            5,                       //max_level
            1000      , 1.0, 0.9,    //{@RXg, {Px̃RXg  , уx̃RXg팸
            60        , 1.0, 0.9,    //{r  , {Px̉rԑ, уx̉rԍ팸
            60        , 1.0, 0.9,    //{  , {Px̔ԑ, уx̔ԍ팸
            60*60*3   , 0.3,         //{  , {Px̎Ԃ̏旦
            0         , 0.0          //{ێRXg, {PẍێRXg̏旦
        ) {

    //I\ԁAEIs
    //    | 0          |  1         |  2 LockonZ |  3 LockonZ |  4 VreathZ|  5 VreathZ|  6 TractorZ|  7 TractorZ|
    //    | 8          |  9         | 10 LockonY | 11 LockonY | 12 VreathY| 13 VreathY| 14 TractorY| 15 TractorY|
    //    | 16         | 17         | 18 LockonX | 19 LockonX | 20 VreathX| 21 VreathX| 22 TractorX| 23 TractorX|
    //    | 24         | 25         | 26 LockonW | 27 LockonW | 28 VreathW| 29 VreathW| 30 TractorW| 31 TractorW|
    //    | 32         | 33         | 34 LockonV | 35 LockonV | 36 VreathV| 37 VreathV| 38 TractorV| 39 TractorV|
    //    | 40 Option]| 41 Option]| 42 LockonU | 43 LockonU | 44 VreathU| 45 VreathU| 46 TractorU| 47 TractorU|
    //    | 48 Option\| 49 Option\| 50 LockonT | 51 LockonT | 52 VreathT| 53 VreathT| 54 TractorT| 55 TractorT|
    //    | 56 Option[| 57 Option[| 58 Empty    | 59 Empty    | 60 Empty   | 61 Empty   | 62 Empty    | 63 Empty    |
    //    | 64 OptionZ| 65 OptionZ| 66 TorpedoZ| 67 TorpedoZ| 68 LaserZ | 69 LaserZ | 70 SpeedZ  | 71 SpeedZ  |
    //    | 72 OptionY| 73 OptionY| 74 TorpedoY| 75 TorpedoY| 76 LaserY | 77 LaserY | 78 SpeedY  | 79 SpeedY  |
    //    | 80 OptionX| 81 OptionX| 82 TorpedoX| 83 TorpedoX| 84 LaserX | 85 LaserX | 86 SpeedX  | 87 SpeedX  |
    //    | 88 OptionW| 89 OptionW| 90 TorpedoW| 91 TorpedoW| 92 LaserW | 93 LaserW | 94 SpeedW  | 95 SpeedW  |
    //    | 96 OptionV| 97 OptionV| 98 TorpedoV| 99 TorpedoV|100 LaserV |101 LaserV |102 SpeedV  |103 SpeedV  |
    //    |104 OptionU|105 OptionU|106 TorpedoU|107 TorpedoU|108 LaserU |109 LaserU |110 SpeedU  |111 SpeedU  |
    //    |112 OptionT|113 OptionT|114 TorpedoT|115 TorpedoT|116 LaserT |117 LaserT |118 SpeedT  |119 SpeedT  |
    //    |120 Empty   |121 Empty   |122 Empty    |123 Empty    |124 Empty   |125 Empty   |126 Empty    |127 Empty    |



//    | 0              | 1              | 2   Tractor U | 3   Tractor U | 4   Tractor T | 5   Tractor T | 6   Vreath  Y | 7   Vreath  Y |
//    | 8              | 9              | 10             | 11             | 12  Empty      | 13  Empty      | 14  Vreath  X | 15  Vreath  X |
//    | 16  Laser   W | 17  Laser   W | 18  Smile   W | 19  Smile   W | 20  Shot    W | 21  Shot    W | 22  Vreath  W | 23  Vreath  W |
//    | 24  Laser   V | 25  Laser   V | 26  Smile   V | 27  Smile   V | 28  Shot    V | 29  Shot    V | 30  Vreath  V | 31  Vreath  V |
//    | 32  Laser   U | 33  Laser   U | 34  Smile   U | 35  Smile   U | 36  Shot    U | 37  Shot    U | 38  Vreath  U | 39  Vreath  U |
//    | 40  Laser   T | 41  Laser   T | 42  Smile   T | 43  Smile   T | 44  Shot    T | 45  Shot    T | 46  Vreath  T | 47  Vreath  T |
//    | 48  Empty      | 49  Empty      | 50  Empty      | 51  Empty      | 52  Empty      | 53  Empty      | 54  Empty      | 55  Empty      |
//    | 56  Option  ] | 57  Option  ] | 58  Torpedo ] | 59  Torpedo ] | 60  Lockon  ] | 61  Lockon  ] | 62  Speed   ] | 63  Speed   ] |
//    | 64  Option  \ | 65  Option  \ | 66  Torpedo \ | 67  Torpedo \ | 68  Lockon  \ | 69  Lockon  \ | 70  Speed   \ | 71  Speed   \ |
//    | 72  Option  [ | 73  Option  [ | 74  Torpedo [ | 75  Torpedo [ | 76  Lockon  [ | 77  Lockon  [ | 78  Speed   [ | 79  Speed   [ |
//    | 80  Option  Z | 81  Option  Z | 82  Torpedo Z | 83  Torpedo Z | 84  Lockon  Z | 85  Lockon  Z | 86  Speed   Z | 87  Speed   Z |
//    | 88  Option  Y | 89  Option  Y | 90  Torpedo Y | 91  Torpedo Y | 92  Lockon  Y | 93  Lockon  Y | 94  Speed   Y | 95  Speed   Y |
//    | 96  Option  X | 97  Option  X | 98  Torpedo X | 99  Torpedo X | 100 Lockon  X | 101 Lockon  X | 102 Speed   X | 103 Speed   X |
//    | 104 Option  W | 105 Option  W | 106 Torpedo W | 107 Torpedo W | 108 Lockon  W | 109 Lockon  W | 110 Speed   W | 111 Speed   W |
//    | 112 Option  V | 113 Option  V | 114 Torpedo V | 115 Torpedo V | 116 Lockon  V | 117 Lockon  V | 118 Speed   V | 119 Speed   V |
//    | 120 Option  U | 121 Option  U | 122 Torpedo U | 123 Torpedo U | 124 Lockon  U | 125 Lockon  U | 126 Speed   U | 127 Speed   U |
//    | 128 Option  T | 129 Option  T | 130 Torpedo T | 131 Torpedo T | 132 Lockon  T | 133 Lockon  T | 134 Speed   T | 135 Speed   T |
//    | 136 Empty      | 137 Empty      | 138 Empty      | 139 Empty      | 140 Empty      | 141 Empty      | 142 Empty      | 143 Empty      |


//    lvinfo_[7].pno_ =  4;
//    lvinfo_[6].pno_ = 12;
    lvinfo_[5].pno_ = 20;
    lvinfo_[4].pno_ = 28;
    lvinfo_[3].pno_ = 36;
    lvinfo_[2].pno_ = 44;
    lvinfo_[1].pno_ = 52;
    lvinfo_[0].pno_ = 60;

    pEffect_ = NEW EffectVreathMagic001("EffectVreathMagic001");
    pEffect_->inactivate();
    addSubGroup(pEffect_);

    for (int i = 0; i <= MMETER_MAX_LEVEL; i++) {
        beat_time_[i]               = 0;
        apaInt_vreath_per_frame_[i] = 0;
        aInt_total_vreath_[i]       = 0;
        r_add_vreath_[i]            = 0.0;
    }
    //P̌ċzԃe[u
    beat_time_[0] = 0.0;
    beat_time_[1] = 180;
    beat_time_[2] = beat_time_[1]/2; //񂾂
    beat_time_[3] = beat_time_[2]/2; //ċz
    beat_time_[4] = beat_time_[3]/2; //
    beat_time_[5] = beat_time_[4]/2; //ȂI
//    beat_time_[6] = beat_time_[5]/2;
//    beat_time_[7] = beat_time_[6]/2;

    //t[ZVreath旦e[u
    for (int lv = 0; lv <= max_level_; lv++) {
        //r_add_vreath_ = - sqrt((max_lv-1)^2 - (lv-1)^2) + max_lv
        //max_level=7 ̏ꍇ
        //lv =7.0   7.0
        //lv =1.0   1.0
        //ƂȂ悤1/4~
        r_add_vreath_[lv] =  -1.0*sqrt((double)(((max_level_-1)*(max_level_-1)) - ((lv-1)*(lv-1)))) + max_level_;
    }

    for (int lv = 0; lv <= max_level_; lv++) {
        if (beat_time_[lv] == 0) {
            apaInt_vreath_per_frame_[lv] = NEW int[1];
            apaInt_vreath_per_frame_[lv][0] = 0;
        } else {
            apaInt_vreath_per_frame_[lv] = NEW int[beat_time_[lv]];
            //O
            for (frame f = 0; f <= beat_time_[lv]/2; f++) {
                int t = f*3600.0/beat_time_[lv];
                apaInt_vreath_per_frame_[lv][f] = MY_SHIP_VREATH_COST*2.0*UTIL::SMOOTH_DV[t];
            }
            //㔼
            for (frame f = beat_time_[lv]/2 + 1; f < beat_time_[lv]; f++) {
                apaInt_vreath_per_frame_[lv][f] = 0; //zȂvreath͖t[MY_SHIP_VREATH_COST
            }
        }
    }
    //ex̑ċz(aInt_total_vreath_[])vZ
    for (int lv = 0; lv <= max_level_; lv++) {
        if (beat_time_[lv] == 0) {
            aInt_total_vreath_[lv] = 0;
        } else {
            int sum_v_onebeat = 0; //1ċz̗̑
            for (frame f = 0; f < beat_time_[lv]; f++) {
                sum_v_onebeat += apaInt_vreath_per_frame_[lv][f] * r_add_vreath_[lv];
            }
            for (frame f = 0; f < beat_time_[lv]; f++) {
                sum_v_onebeat -= MY_SHIP_VREATH_COST;
            }
            //ċz񐔂悶đċzʂvZ
            aInt_total_vreath_[lv] = sum_v_onebeat * ((1.0 * lvinfo_[lv].effecting_frames_) / beat_time_[lv]);
        }
    }
}

void VreathMagic::onReset() {
    Magic::onReset();
    pEffect_->inactivate();
}

void VreathMagic::processCastBegin(int prm_now_level, int prm_new_level) {
    if (prm_new_level > prm_now_level) {
        pEffect_->setPositionAt(P_MYSHIP);
        pEffect_->setAlpha(0.9);
        pEffect_->getKuroko()->setFaceAngVelo(AXIS_Z, 100);
        pEffect_->setScale(1000);
        pEffect_->activate();
    }
}

void VreathMagic::processCastingBehavior(int prm_now_level, int prm_new_level) {
    if (prm_new_level > prm_now_level) {
        pEffect_->setPositionAt(P_MYSHIP);
        pEffect_->addScale(10);
    }
}

void VreathMagic::processCastingCancel(int prm_now_level) {
    pEffect_->inactivate();
}

void VreathMagic::processCastFinish(int prm_now_level, int prm_new_level, int prm_result_invoke) {
}

void VreathMagic::processInvokeBegin(int prm_now_level, int prm_new_level) {
    if (prm_new_level > prm_now_level) {
        pEffect_->setScale(1000);
        pEffect_->getKuroko()->setFaceAngVelo(AXIS_Z, 3000);
    }
}

void VreathMagic::processInvokingBehavior(int prm_now_level, int prm_new_level) {
    if (prm_new_level > prm_now_level) {
        pEffect_->addScale(100);
    }
}

void VreathMagic::processInvokingCancel(int prm_now_level) {
    pEffect_->inactivate();
}

void VreathMagic::processInvokeFinish(int prm_now_level, int prm_new_level, int prm_result_effect) {
    pEffect_->inactivate();
}

void VreathMagic::processEffectBegin(int prm_last_level, int prm_now_level) {
    if ( prm_now_level > 0) {
    } else {
        //x0փx_E
        pEffect_->inactivate();
    }
}
void VreathMagic::processEffectingBehavior(int prm_last_level, int prm_now_level) {
    if (beat_time_[prm_now_level] > 0) {
        frame f = getActiveFrame() % beat_time_[prm_now_level];
#ifdef MY_DEBUG
        if (f > beat_time_[prm_now_level]) {
            throwGgafCriticalException("͈͊OłB f="<<f<<" beat_time_["<<prm_now_level<<"]");
        }
#endif
        int add_vreath = apaInt_vreath_per_frame_[prm_now_level][f] * r_add_vreath_[prm_now_level];
        P_MYSHIP->getStatus()->plus(STAT_Stamina, add_vreath);
    } else {

    }
}

int VreathMagic::calcTotalVreath(int prm_now_level, int prm_target_up_level) {
    int sum_vreath = 0;
    for (int lv = prm_now_level+1; lv <= prm_target_up_level; lv++) {
        sum_vreath += aInt_total_vreath_[lv];
    }
    return sum_vreath;
}

VreathMagic::~VreathMagic() {
    for (int lv = 0; lv <= max_level_; lv++) {
        GGAF_DELETEARR(apaInt_vreath_per_frame_[lv]);
    }
}
