#ifndef MYSHIP_H_
#define MYSHIP_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/actor/DefaultD3DXMeshActor.h"

#include "jp/ggaf/lib/util/Quantity.hpp"
#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"
#include "jp/ggaf/dxcore/util/GgafDxGeoElem.h"

namespace VioletVreath {

//#define MY_SHIP_VREATH_COST (500)
//ċz 1000000/500/60 = 33.3bŎ

/** t[Vreath */
#define MY_SHIP_VREATH_COST (5)
//ċz 10000/5/60 = 33.3bŎ

/** őMP */
#define MY_SHIP_MAX_MP (1000000)
/** MP */
#define MY_SHIP_START_MP (1000000)
/** @̈ړ~ĂAg[XȏԂێłt[ */
#define TRACE_DELAY_WAIT_FRAME (0x7fffffff)

#define MYSHIP_SHOT_MATRIX (7)



/**
 * @NX
 * @version 1.00
 * @since 2006/06/22
 * @author Masatoshi Tsuge
 */
class MyShip : public GgafLib::DefaultD3DXMeshActor {
//class MyShip : public GgafLib::DefaultMeshActor {
//class MyShip : public GgafLib::CubeMapMeshActor {
//class MyShip : public GgafLib::DefaultD3DXAniMeshActor {
public:
    enum Switch {
        SW_ADD = 1,
        SW_NOP = 0,
        SW_SUB = -1
    };

    enum {
        SE_DAMAGED     ,
        SE_EXPLOSION   ,
        SE_TURBO       ,
        SE_CANT_TURBO  ,
        SE_FIRE_LASER  ,
        SE_FIRE_SHOT   ,
        SE_FIRE_TORPEDO,
    };

public:
    /** ړYW */
    static coord lim_y_top_;
    /** ړYW */
    static coord lim_y_bottom_;
    /** ړXW */
    static coord lim_x_infront_;
    /** ړXW */
    static coord lim_x_behaind_;
    /** ړZW */
    static coord lim_z_left_;
    /** ړZW */
    static coord lim_z_right_;

    static uint32_t shot2_matrix_[4][MYSHIP_SHOT_MATRIX];
    static uint32_t shot3_matrix_[2][MYSHIP_SHOT_MATRIX];
    /** sړx */
    GgafDxCore::GgafDxAxesMover* pAxsMver_;

    angle senakai_[3*3*3];
    angle* pSenakai_;

    /** [r]bNIRg[[ */
    MyLockonController* pLockonCtrler_;
    /** [r]Rg[[ */
    MyTorpedoController* pTorpedoCtrler_;

    /** ^[{Aړp */
    int way_;
    int prev_way_;
    bool is_just_change_way_;
    /** ړXs[hxɑړXs[h */
    velo mv_speed_;

    velo veloTurboTop_;
    velo veloTurboBottom_;

    /** TurboړJn̈ړx̏x */
    velo veloBeginMT_; //Move Velo when I Begin To Move with Turbo
    //ZޏꍇA܂̒lvZ悤iZ̈ړx͐ŊǗĂ邽߁j

    /** (+Z)͎O(-Z)֒ʏړJnX]px̏x */
    angvelo angRxVelo_BeginMZ_; //Rotation axisX angle Velo when I Begin To Move Z
    //̏ꍇ͐AȌꍇ͂ -1 悸

    /** (+Z)͎O(-Z)֒ʏړX]px̊px */
    angacce angRxAcce_MZ_; //Rotation axisX angle Acce while I Move Z
    //̏ꍇ͐AȌꍇ͂ -1 悸

    /** (+Z)͎O(-Z)ֈړX]px̏px */
    angvelo angRxTopVelo_MZ_; //Rotation axisX Top angle Velo while I Move Z
    //px͂ -1 悸

    /** (+Z)͎O(-Z)֒ʏZړX]p̒~px */
    angle angRxStop_MZ_; //Rotation axisX Stop angle while I Move Z


    /** (+Y)͉(-Y)TurboړJnZ]px̏x */
    angvelo angRxVelo_BeginMZT_; //Rotation axisX angle Velo when I Begin To Move Z with Turbo
    //̏ꍇ͐Ȁꍇ͂ -1 悸

    GgafCore::GgafActorDepository* pDepo_MyShots001_;
    GgafCore::GgafActorDepository* pDepo_MySnipeShots001_;
    GgafLib::LaserChipDepository* pLaserChipDepo_;

    EffectTurbo001* pEffectTurbo001_;
    MyMagicEnergyCore* pMyMagicEnergyCore_;
//    //debug ---->
//    GgafCore::GgafActorDepository* pDepo_TestGuShot_;
//    GgafCore::GgafActorDepository* pDepo_TestChokiShot_;
//    GgafCore::GgafActorDepository* pDepo_TestPaShot_;
//    GgafCore::GgafActorDepository* pDepo_TestNomalShot_;
//    //<---- debug


    /** \tgA˔ł邩ۂ */
    bool is_being_soft_rapidshot_;

    /** \tgA˂JnĂ̔ːJEgv */
    uint32_t soft_rapidshot_shot_count_;
    /** \tgA˂JnẴvbVJEg */
    int soft_rapidshot_push_cnt_;

    /** PvbṼ\tgAˊJňo߃t[ */
    frame soft_rapidshot_frames_in_one_push;
    /** PvbṼ\tgAˊJn̔ːJEg */
    int soft_rapidshot_shot_count_in_one_push_;

    /** Vbgt[̂ true ɂȂ */
    bool is_just_shot_;
    /** Vbg擪̈ꔭڂ̃XiCvVbgۂAXiCvVbg̎̂ true ɂȂ */
    bool is_snipe_shot_;

    /** [U[˒ǂ */
    bool is_shooting_laser_;
    /** [U[ˉ\ǂ */
    bool can_shoot_laser_;
    /** SHOT{^ςȂo߃t[i[U[ˊJn̂߁j */
    frame frame_shot_pressed_;
    /** V[˓ǂ */
    bool is_diving_;

    /**  */
    bool can_control_;

    /** X */
    int blown_veloX_;
    /** Y */
    int blown_veloY_;
    /** Z */
    int blown_veloZ_;

    /** ь */
    double r_blown_velo_decay_;

    /** MP */
    int mp_;

    int invincible_frames_;

    /** @[^[ */
    MagicMeter* pMagicMeter_;
    /** IvVg[X@~̍ۂɁAIɃIvV߂܂ł̗P\ɂ~true */
    bool is_trace_waiting_;
    /** is_trace_waiting_̃tO؂ւ邽߂̎ԃJE^ */
    frame trace_delay_count_;


    int shot_level_;

    /** SHOT1+SHOT2̃̕JE^[ */
    int center_wepon_launch_count_;


    coord prev_x_;
    coord prev_y_;
    coord prev_z_;
    coord mv_offset_x_;
    coord mv_offset_y_;
    coord mv_offset_z_;
    bool is_move_;
public:
    MyShip(const char* prm_name);

    void onCreateModel() override;

    void initialize() override;

    void onReset() override;

    void onActive() override;
    void onInactive() override;
    void processBehavior() override;

    void processJudgement() override;

    void onHit(const GgafCore::GgafActor* prm_pOtherActor) override;

    void setMoveSpeed(velo prm_speed_velo);

    int getMoveWay();

    void moveNomal(dir26 prm_way);

    void moveTurbo(dir26 prm_way);


    void onCatchEvent(hashval prm_no, void* prm_pSource) override;

    /**
     * @ .
     * @param prm_blown_veloX Xёx
     * @param prm_blown_veloY Yёx
     * @param prm_blown_veloZ Zёx
     * @param prm_r_blown_velo_attenuate ь
     */
    void setBlownVelo(velo prm_blown_veloX, velo prm_blown_veloY, velo prm_blown_veloZ, double prm_r_blown_velo_attenuate);
    /**
     * @Gݒ .
     * @param prm_frames G(t[)
     */
    void setInvincibleFrames(int prm_frames);

    /**
     * @\ȏԂǂ B
     * @return
     */
    inline bool canControl() {
        return can_control_;
    }

    virtual ~MyShip();

};

}
#endif /*MYSHIP_H_*/

