#include "GameScene.h"

#include "jp/ggaf/core/actor/GgafSceneDirector.h"
#include "jp/ggaf/dxcore/scene/supporter/GgafDxBgmPerformerForScene.h"

#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/ggaf/core/util/GgafLinearOctree.h"
#include "jp/ggaf/core/util/GgafLinearTreeRounder.hpp"
#include "jp/gecchi/VioletVreath/actor/menu/pause/MenuBoardPause.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/CommonScene.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/GameBeginningScene.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/GameDemoScene.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/GameEndingScene.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/GameMainScene.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/GameMainScene/StageWorld.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/GameOverScene.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/GamePreTitleScene.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/GameTitleScene.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/PreDrawScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;


GameScene::GameScene(const char* prm_name) : DefaultScene(prm_name) ,
pCommonScene_(nullptr),
pMyShipScene_(nullptr),
pStageWorld_(nullptr) {

    _class_name = "GameScene";
    useProgress(PROG_BANPEI-1);
    pCommonScene_ = NEW CommonScene("Common");
    pCommonScene_->inactivate();
    addSubLast(pCommonScene_);
    pMyShipScene_ = NEW MyShipScene("MyShipScene");
    pMyShipScene_->inactivate();
    addSubLast(pMyShipScene_);
    pStageWorld_ = new StageWorld("StageWorld");
    pStageWorld_->inactivate();
    addSubLast(pStageWorld_);

    pMenuBoardPause_ = NEW MenuBoardPause("MenuBoardPause");
    bringDirector()->addSubGroup(pMenuBoardPause_);

    addSubLast(NEW GamePreTitleScene("PreGameTitle"));
    addSubLast(NEW GameTitleScene("GameTitle"));
    addSubLast(NEW GameDemoScene("GameDemo"));
    addSubLast(NEW GameBeginningScene("GameBeginning"));
    addSubLast(NEW GameMainScene("GameMain"));
    addSubLast(NEW GameEndingScene("GameEnding"));
    addSubLast(NEW GameOverScene("GameOver"));

    getProgress()->relateSubScene(PROG_PRE_TITLE, PROG_GAME_OVER,  "PreGameTitle");
    is_frame_advance_ = false;

    was_paused_flg_GameMainScene_prev_frame_ = false;

    getBGMer()->ready(0, "OGG_BGM_DEMO");
}

void GameScene::initialize() {
    _TRACE_(FUNC_NAME<<" ܂DemoScene");
}

void GameScene::onReset() {
    VB_UI->clear();
    P_GOD->setVB(VB_UI);
    DefaultScene* pSubScene;
    SceneProgress* pProg = getProgress();
    for (ProgSceneMap::const_iterator it = pProg->_mapProg2Scene.begin(); it != pProg->_mapProg2Scene.end(); ++it) {
        pSubScene = it->second;
        if (pSubScene) {
            pSubScene->resetTree();
            pSubScene->fadeinSceneTree(0);
            pSubScene->inactivate();
        }
    }
    P_GOD->getSpacetime()->resetCamWorker();
    G_RANK = 0.0;
    G_RANKUP_LEVEL = 0;
    G_SCORE = 0;
    pProg->reset(PROG_INIT);
}

void GameScene::onActive() {
}

void GameScene::processBehavior() {
    Spacetime* pSpacetime = P_GOD->getSpacetime();
#ifdef MY_DEBUG
    //Ct[\ؑ
    if (VB->isPushedDown(VB_UI_DEBUG) || GgafDxInput::isPushedDownKey(DIK_Q)) {
        if (GgafDxGod::_d3dfillmode == D3DFILL_WIREFRAME) {
            GgafDxGod::_d3dfillmode = D3DFILL_SOLID;
        } else {
            GgafDxGod::_d3dfillmode = D3DFILL_WIREFRAME;
        }
    }
#endif
    SceneProgress* pProg = getProgress();
    switch (pProg->getFromProgOnChange()) {
        case PROG_MAIN: {
            _TRACE_(FUNC_NAME<<" Prog has Just Changed 'From' PROG_MAIN");
            VB_UI->clear();
            P_GOD->setVB(VB_UI);  //ɖ߂
            break;
        }

        default: {
            break;
        }
    }


    switch (pProg->get()) {
        case PROG_INIT: {
//            _TRACE_(FUNC_NAME<<" Prog(=PROG_INIT) has Just Changed");
            //P_GOD->syncTimeFrame(); //`𒆎~āAt[ƎԂ̓s
            if ((pProg->hasArrivedAt(120))) {
                _TRACE_("P_GOD->_fps = "<<P_GOD->_fps);
                pProg->changeWithSceneCrossfading(PROG_PRE_TITLE);
                World* pWorld = pSpacetime->getWorld();
                pWorld->pPreDrawScene_->inactivateTreeImmed();
                pWorld->pPreDrawScene_->pauseTreeImmed();
                getBGMer()->stop();
            }
            break;
        }

        case PROG_PRE_TITLE: {
            //##########  ^CgOo  ##########
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed (to PROG_PRE_TITLE)");
                getBGMer()->play_fadein(0);
            }
            //VB_UI_EXECUTE ŁAXLbvTITLE
            if (VB->isPushedDown(VB_UI_EXECUTE)) { //skip
                pProg->changeWithSceneFlipping(PROG_TITLE);
            }
            //EVENT_PREGAMETITLESCENE_FINISH Cxgt
            break;
        }

        case PROG_TITLE: {
            //##########  ^Cg  ##########
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed (to PROG_TITLE)");
            }
            //Cxg҂ EVENT_GAMETITLESCENE_FINISH or EVENT_GAMESTART
            break;
        }

        case PROG_DEMO: {
            //##########  f  ##########
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed (to PROG_DEMO)");
            }
            //VB_UI_EXECUTE ŁAXLbvTITLE
            if (VB->isPushedDown(VB_UI_EXECUTE)) {
                pProg->changeWithSceneFlipping(PROG_TITLE);
            }

            // EVENT_GAMEDEMOSCENE_FINISH Cxgt
            break;
        }

        case PROG_BEGINNING: {
            //##########  Q[Jni[hI𓙁j  ##########
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed (to PROG_BEGINNING)");
                getBGMer()->fadeout_stop();
            }
            //Cxg҂ EVENT_GAMEMODE_DECIDE
            break;
        }

        case PROG_MAIN: {
            //##########  Q[C  ##########
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed (to PROG_MAIN)");
                VB_PLAY->clear();
                P_GOD->setVB(VB_PLAY); //vCpɕύX
            }

            //|[Ył͂Ȃ
            if (!pProg->getGazedScene()->wasPaused()) {
                if (was_paused_flg_GameMainScene_prev_frame_)  {
                    //t[|[Ył͂ȂAOt[|[Y̏ꍇB
                    //|[Yŏ̃t[̓RR
                    pSpacetime->undoCameraWork();
                }

                //ʏis̓RR
                //
#ifdef MY_DEBUG
                if (VB->isPushedDown(VB_PAUSE) || GgafDxInput::isPushedDownKey(DIK_ESCAPE) || is_frame_advance_) {
                    //|[Ył͂ȂƂɁA|[YL[ėꍇ̏
                    //|[Y̏̓RR
                    pauseGame();
                }
#else
                if (VB->isPushedDown(VB_PAUSE) || is_frame_advance_) {
                    //|[Ył͂ȂƂɁA|[YL[ėꍇ̏
                    //|[Y̏̓RR
                    pauseGame();
                }
#endif
            }
            //|[Y
            if (pProg->getGazedScene()->wasPaused()) {
                if (was_paused_flg_GameMainScene_prev_frame_ == false) {
                    //t[|[YŁAOt[|[Ył͂Ȃꍇ
                    //|[ÝAŏ̃t[̓RR
                    GgafDxInput::updateMouseState();
                    GgafDxInput::updateMouseState(); //}EXW̑΍W0ɃZbg邽
                                                     //AQĂяo
                    pSpacetime->changeCameraWork("PauseCamWorker");
                }

                //|[Yis̓RR
                //

                if (pMenuBoardPause_->hasJustSunk() || is_frame_advance_) {
                    //|[YɁA|[YL[ėꍇ̏
                    //|[Y̏̓RR
                    _TRACE_("UNPAUSE!");
                    P_GOD->setVB(VB_PLAY);
                    pProg->getGazedScene()->unpauseTree();//|[YII
                }
            }
            //Cxg҂ EVENT_ALL_MY_SHIP_WAS_DESTROYED
            break;
        }

        case PROG_ENDING: {
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed (to PROG_ENDING)");
            }
            break;
        }

        case PROG_GAME_OVER: {
            //##########  Q[I[o[  ##########
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed (to PROG_GAME_OVER)");
            }
            //Cxg҂ EVENT_GAME_OVER_FINISH
            break;
        }

        case PROG_FINISH: {
            //##########  Q[V[I  ##########
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed (to PROG_FINISH)");
                DefaultScene* pSubScene;
                for (ProgSceneMap::const_iterator it = pProg->_mapProg2Scene.begin(); it != pProg->_mapProg2Scene.end(); ++it) {
                    pSubScene = it->second;
                    if (pSubScene) {
                        pSubScene->fadeoutSceneWithBgmTree(FADE_FRAMES);
                        pSubScene->inactivateDelay(FADE_FRAMES);
                    }
                }
            }
            if (pProg->hasArrivedAt(FADE_FRAMES+10)) {
                reset(); //Zbgiŏ̐iԂɖ߂j
            }
            break;
        }

        default: {
            break;
        }
    }

    DefaultScene* pGazed = pProg->getGazedScene();
    if (pGazed) {
        was_paused_flg_GameMainScene_prev_frame_ = pGazed->wasPaused();
    }

}

void GameScene::onCatchEvent(hashval prm_no, void* prm_pSource) {
//    switch (prm_no) {
//        case EVENT_GOD_WILL_DEMISE:
//
//            break;
//        default:
//            break;
//    }
    SceneProgress* pProg = getProgress();
    if (prm_no == EVENT_GOD_WILL_DEMISE) {
        _TRACE_("GameScene::onCatchEvent(EVENT_GOD_WILL_DEMISE) CommonSceneEグČɉ悤ɂ܂B");
        //_ł܂O
        //CommonSceneEグAɂȂ悤ɑ삷B(Lf|WgƂ邵)
        addSubLast(P_MYSHIP_SCENE->extract());
        addSubLast(P_COMMON_SCENE->extract());
        P_MYSHIP_SCENE->moveFirst();
        P_COMMON_SCENE->moveFirst();
        //moveFirst()闝ŔA͖m[hs邽߁B
        //CommonSceneȂ悤ɂ邽߁B
        //GgafCore::template<class T> GgafNode<T>::~GgafNode() ̃RgQ
    } else if (prm_no == EVENT_PREGAMETITLESCENE_FINISH) {
        //v^CgV[I
        _TRACE_("GameScene::onCatchEvent(EVENT_PREGAMETITLESCENE_FINISH)");
        pProg->changeWithSceneFlipping(PROG_TITLE); //^Cg

    } else if (prm_no == EVENT_GAMETITLESCENE_FINISH) {
        //^CgV[{[ƌĂ̂ŎԐ؂I
        _TRACE_("GameScene::onCatchEvent(EVENT_GAMETITLESCENE_FINISH)");
        pProg->changeWithSceneCrossfading(PROG_DEMO); //f

    } else if (prm_no == EVENT_GAMEDEMOSCENE_FINISH) {
        //fV[I
        _TRACE_("GameScene::onCatchEvent(EVENT_GAMEDEMOSCENE_FINISH)");
        pProg->changeWithSceneFadeoutFadein(PROG_INIT,120,120); //ŏ
        getBGMer()->fadeout_stop();

    } else if (prm_no == EVENT_GAMESTART) {
        //X^[g
        _TRACE_("GameScene::onCatchEvent(EVENT_GAMESTART)");
        pProg->changeWithSceneCrossfading(PROG_BEGINNING); //I[vjOiQ[[hZNgj

    } else if (prm_no == EVENT_GAMEMODE_DECIDE) {
        //Q[[hZNg
        _TRACE_("GameScene::onCatchEvent(EVENT_GAMEMODE_DECIDE)");
        pProg->changeWithSceneCrossfading(PROG_MAIN,600);//C
    } else if (prm_no == EVENT_GOTO_GAMETITLE) {
        //Ƃɂ^CgփCxg
        _TRACE_("GameScene::onCatchEvent(EVENT_GOTO_GAMETITLE)");
        pProg->changeWithSceneFlipping(PROG_TITLE); //^Cg
    }


    if (prm_no == EVENT_ALL_MY_SHIP_WAS_DESTROYED) {
        _TRACE_("GameScene::onCatchEvent(EVENT_ALL_MY_SHIP_WAS_DESTROYED)");
        if (pProg->get() == PROG_DEMO) {
            //AfV[̑S@łȂ΁AfV[I
            pProg->changeWithSceneFadeoutFadein(PROG_INIT, 120, 120); //ŏ
            getBGMer()->fadeout_stop();
        } else {
            pProg->changeWithSceneCrossfading(PROG_GAME_OVER); //Q[I[o[
        }
    } else if (prm_no == EVENT_GAMEOVERSCENE_FINISH) {
        _TRACE_("GameScene::onCatchEvent(EVENT_GAMEOVERSCENE_FINISH)");
        pProg->change(PROG_FINISH);
    } else if (prm_no == EVENT_GO_TO_TITLE) {
        _TRACE_("GameScene::onCatchEvent(EVENT_GO_TO_TITLE)");
        _TRACE_("UNPAUSE!(because EVENT_GO_TO_TITLE)");
        P_GOD->setVB(VB_PLAY);
        pProg->getGazedScene()->unpauseTree();//|[YII
        pProg->change(PROG_FINISH);
    }
}


void GameScene::processJudgement() {

    if (getBehaveingFrame() >= 120) {
#ifdef MY_DEBUG
        CollisionChecker::_num_check = 0;
#endif


        //{V[̏V[̏AN^[SĂɂē蔻`FbNsB
        //ԕ()ASYɂA`FbN񐔂̍œKsĂ܂B
        //ڍׂ uʑ֒`Rsyc[.xlsv  uʑցv V[gQ

        GgafLinearTreeRounder<GgafActor, 3>* pHitCheckRounder = P_GOD->getSpacetime()->getLinearOctreeHitCheckRounder();
#ifdef MY_DEBUG
        if (GgafDxInput::isPushedDownKey(DIK_I)) {
            P_GOD->getSpacetime()->getLinearOctree()->putTree();
        }
#endif
        //؃ASYŃqbg`FbN
        pHitCheckRounder->executeAll(
            KIND_CHIKEI,
            KIND_MY_CHIKEI_HIT|KIND_ENEMY_CHIKEI_HIT|KIND_ITEM_CHIKEI_HIT|KIND_CHIKEI_CHIKEI_HIT
        );
        pHitCheckRounder->executeAll(
            KIND_ITEM,
            KIND_MY_BODY_CHIKEI_HIT
        );
        pHitCheckRounder->executeAll(
            KIND_MY,
            KIND_ENEMY_BODY
        );
        pHitCheckRounder->executeAll(
            KIND_ENEMY_SHOT,
            KIND_MY_BODY
        );


    }
}
void GameScene::pauseGame() {
    is_frame_advance_ = false;
    _TRACE_("PAUSE!");
    P_GOD->setVB(VB_UI);  //͂͂thɐ؂ւ
    getProgress()->getGazedScene()->pauseTree(); //|[YII
    pMenuBoardPause_->rise(PX_C(100), PX_C(20));
}

GameScene::~GameScene() {
}
