#ifndef GAMESCENE_H_
#define GAMESCENE_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/scene/DefaultScene.h"

#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World.h"

namespace VioletVreath {

#define P_GAME_SCENE (P_GOD->getSpacetime()->getWorld()->pGameScene_)

/**
 * Q[V[NX .
 * w̐(Spacetime)́AƂ鐢E(World)ŁAQ[sȂĂ(GameScene)܂Bx<BR>
 * ƂTǑɐ݌vs܂B<BR>
 * {NX́AQ[̑S̓IȐU镑Ă܂B<BR>
 * ɁATuV[̐؂ւs܂B<BR>
 * @version 1.00
 * @since 2007/11/16
 * @author Masatoshi Tsuge
 */
class GameScene : public GgafLib::DefaultScene {

public:

    enum {
        PROG_INIT      ,
        PROG_PRE_TITLE ,
        PROG_TITLE     ,
        PROG_DEMO      ,
        PROG_BEGINNING ,
        PROG_MAIN      ,
        PROG_ENDING    ,
        PROG_GAME_OVER ,
        PROG_FINISH    ,
        PROG_BANPEI,
    };


    CommonScene* pCommonScene_;
    MyShipScene* pMyShipScene_;

    MenuBoardPause* pMenuBoardPause_;
    /** GameMainÁADemo̔zֈړ */
    StageWorld* pStageWorld_;

    /** R}tO */
    bool is_frame_advance_;
    /** Pt[OAGameMainSceneꎞ~Ԃǂ */
    bool was_paused_flg_GameMainScene_prev_frame_;

public:
    GameScene(const char* prm_name);

    void onReset() override;
    void initialize() override;
    void onActive() override;

    void processBehavior() override;
    void processJudgement() override;

    void onCatchEvent(hashval prm_no, void* prm_pSource) override;

    void pauseGame();

    virtual ~GameScene();

};

}
#endif /*GAMESCENE_H_*/
