class VoiceArchiveValidator < ActiveModel::EachValidator
  def validate_each(record, attr, value)
    has_ogg = false
    has_manifest = false

    begin
      Zip::ZipFile.open(value.queued_for_write[:original].path) do |zf|
        zf.each do |ze|
          ze.name.index "/" and raise "contains directory."
          !has_manifest && ze.name.downcase == "messages.xml" and
            has_manifest = true
          !has_ogg && File.extname(ze.name).downcase == ".ogg" and
            has_ogg = true
        end
      end
      has_ogg      or raise "No ogg files."
      has_manifest or raise "messages.xml is missing."
    rescue => e
      record.errors[attr] << "is invalid: #{e.message}"
    end
  end
end
