/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package iterator;

import java.util.Iterator;
import java.util.function.Function;

/**
 *
 * @author mtomono
 * @param <E> input
 * @param <F> result
 */
public class MapIterator<E, F> implements Iterator<F> {
    Iterator<E> base;
    Function<E, F> map;
    
    public MapIterator(Iterator<E> base, Function<E, F> map) {
        this.base = base;
        this.map  = map;
    }
    
    @Override
    public boolean hasNext() {
        return base.hasNext();
    }

    @Override
    public F next() {
        return map.apply(base.next());
    }
    
}
