/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package orderedSet;

import debug.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 *
 * @author mtomono
 */
public class Between<T extends Comparable<T>> extends Range<T> {
    T start;
    T end;
    Order<T> order;
    
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Between))
            return false;
        return order.eq(this.start, ((Between<T>)o).start) && order.eq(this.end, ((Between<T>)o).end);
    }

    protected Between() {
        
    }
    
    @Override
    public Range<T> clone() {
        return new Between<>(start, end, order);
    }
    
    public Between(T start, T end, Order<T> order) {
        assert order.le(start, end);
        this.start = start;
        this.end = end;
        this.order = order;
    }
    
    public Between(T start, T end) {
        this(start, end, Default.order);
    }
    
    static public <T extends Comparable<T>> List<Range<T>> c(Order<T> order, T... range) {
        if (range.length == 0) {
            return Collections.<Range<T>>emptyList();
        } else if (range.length % 2 != 0) {
            throw new RuntimeException("Range(T...) illegal number of parameters");
        } else {
            List<Range<T>> retval = new ArrayList<>(range.length / 2);
            for (int i = 0; i < range.length; i += 2) {
                retval.add(new Between<>(range[i], range[i+1], order));
            }
            return retval;
        }
    }

    @Override
    public boolean isEmpty() {
        return order.eq(start, end);
    }
    
    public T getStart() {
        return start;
    }
    
    public T getEnd() {
        return end;
    }
    
    @Override
    public boolean startsAt(T value) {
        return order.eq(start, value);
    }
    
    @Override
    public boolean endsAt(T value) {
        return order.eq(end, value);
    }
    
    /**
     * if contains value<->value
     * @param value
     * @return 
     */
    @Override
    public boolean contains(T value) {
        return order.le(this.start, value) && order.lt(value, this.end);
    }
    
    /**
     * for all value in values, contains value<->value
     * @param values
     * @return 
     */
    @Override
    public boolean contains(List<T> values) {
        return values.stream().allMatch(this::contains);
    }
    
    @Override
    public boolean contains(Range<T> another) {
        return !another.hasLowerThan(start) && !another.hasUpperThan(end);
    }
    
    @Override
    public boolean overlaps(List<T> values) {
        return values.stream().anyMatch(this::contains);
    }
    
    @Override
    public boolean overlaps(Range<T> another) {
        return another.hasUpperThan(start) && another.hasLowerThan(end);
    }

    /**
     * comparison to value<->value
     * @param value
     * @return 
     */
    @Override
    public boolean hasLowerThan(T value) {
        return order.lt(this.start, value);
    }
    
    /**
     * comparison to value<->value
     * @param value
     * @return 
     */
    @Override
    public boolean hasUpperThan(T value) {
        return order.lt(value, this.end);
    }
    
    @Override
    public boolean startsUpperThan(Range<T> another) {
        return another.hasLowerThan(start);
    }
    
    @Override
    public boolean endsLowerThan(Range<T> another) {
        return another.hasUpperThan(end);
    }
    
    @Override
    public boolean isLowerThan(Range<T> another) {
        return !another.hasLowerThan(end);
    }
    
    @Override
    public boolean isUpperThan(Range<T> another) {
        return !another.hasUpperThan(start);
    }
    
    /**
     * comparison to value<->value
     * @param value
     * @return 
     */
    @Override
    public boolean isBelow(T value) {
        return order.lt(end, value);
    }
    
    /**
     * comparison to value<->value
     * @param value
     * @return 
     */
    @Override
    public boolean isAbove(T value) {
        return order.lt(value, start);
    }
    
    @Override
    public boolean isBelow(Range<T> another) {
        return another.isAbove(end);
    }
    
    @Override
    public boolean isAbove(Range<T> another) {
        return another.isBelow(start);
    }

    @Override
    public boolean adjoins(Range<T> another) {
        return adjoinsAtStartWith(another) || adjoinsAtEndWith(another);
    }
    
    @Override
    public boolean adjoinsAtStartWith(Range<T> another) {
        return another.endsAt(start);
    }

    @Override
    public boolean adjoinsAtEndWith(Range<T> another) {
        return another.startsAt(end);
    }
    
    @Override
    public Range<T> intersect(Range<T> another) {
        return another.getUpper(start).getLower(end);
    }
    
    @Override
    public Range<T> cover(T value) {
        if (!hasUpperThan(value))
            return new Between<>(start, value, order);
        if (!hasLowerThan(value))
            return new Between<>(value, end, order);
        return this;
    }
    
    @Override
    public Range<T> cover(Range<T> another) {
        return another.cover(start).cover(end);
    }
    
    @Override
    public Range<T> getLower(T value) {
        if (hasLowerThan(value)) {  //バリは要らないので
            return new Between<>(this.start, hasUpperThan(value) ? value : this.end, order);
        } else {
            return new Empty<>();
        }
    }
    
    @Override
    public Range<T> getUpper(T value) {
        if (hasUpperThan(value)) {
            return new Between<>(hasLowerThan(value) ? value : this.start, this.end, order);
        } else {
            return new Empty<>();
        }
    }
    
    @Override
    public Range<T> getLowerRoomIn(Range<T> another) {
        return another.getLower(start);
    }
    
    @Override
    public Range<T> getUpperRoomIn(Range<T> another) {
        return another.getUpper(end);
    }
    @Override
    public String toString() {
        return Format.<T>between(this.start, this.end, null);
    }
    
    @Override
    public T start() {
        return start;
    }
    
    @Override
    public T end() {
        return end;
    }
}
