/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package view;

import java.util.AbstractList;
import java.util.List;
import java.util.function.IntSupplier;
import static function.Pipe.*;
import static java.lang.Math.max;

/**
 *
 * @author mtomono
 * @param <E>
 */
public class ViewList<E> extends AbstractList<View<E>> {
    IntSupplier start;
    IntSupplier end;
    View<E> view;
    
    public static <E> ViewList<E> natural(View<E> view) {
        return new ViewList<>(view, view.start(), view.end());
    }

    public static <E> ViewList<E> reverse(View<E> view) {
        return new ViewList<>(view, p(view.start(), v->v + 1-view.size()), p(view.end(), v->v + 1-view.size()));
    }

    public static <E> ViewList<E> outer(View<E> view) {
        return new ViewList<>(view, p(view.start(), v->v + 1-view.size()), view.end());
    }
    
    public static <E> ViewList<E> inner(View<E> view) {
        return new ViewList<>(view, view.start(), p(view.end(), v->v + 1-view.size()));
    }

    public ViewList(View<E> base, IntSupplier start, IntSupplier end) {
        this.view = base;
        this.start = start;
        this.end = end;
    }
    
    public View<E> getView() {
        return view;
    }
    
    @Override
    public View<E> get(int index) {
        return view.index(index + start.getAsInt());
    }

    @Override
    public int size() {
        return max(end.getAsInt() - start.getAsInt(), 0);
    }
    
}
