//
//  MainController.h
//  Etokicho
//
//  Created by 二鏡 on 11/11/13.
//  Copyright 2011年 二鏡庵. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ECProject.h"
#import "ECRenderer.h"
#import "ConfigurationManager.h"
#import "ECSceneComposition.h"
#import "ECTimelineManager.h"
#import "ECProject.h"

@interface MainController : NSObject <ECRendererDelegate>
{
    ECSceneComposition *composition;
    ECRenderer *renderer;
    BOOL renderingWillStop;
    struct {
        BOOL isMovieCompleted;
        NSRange range; // {NF,NF} -> invalid, {0,0} -> all
    } preview;
    
    ConfigurationManager *configuration;
    ECTimelineManager *timelineManager;
    
    ECProject *project; // current project
}
@property (readonly) ECTimelineManager *timelineManager;
@property (readonly) ConfigurationManager *configurationManager;
@property (readwrite,retain) ECProject *project;

- (IBAction)toggleComposition:(id)sender;

- (IBAction)toggleImageBrowser:(id)sender;
- (IBAction)toggleLayerPropertyPanel:(id)sender;
- (IBAction)toggleScenePropertyPanel:(id)sender;
- (IBAction)toggleStoryboardPanel:(id)sender;
- (IBAction)toggleGeneratorProperty:(id)sender;
- (IBAction)toggleTextPanel:(id)sender;
- (IBAction)toggleTextImporter:(id)sender;
- (IBAction)toggleProjectStatics:(id)sender;
- (IBAction)closeProject:(id)sender;

- (IBAction)stopRender:(id)sender;
- (IBAction)renderMovie:(id)sender;
- (IBAction)renderMovieLight:(id)sender;
- (IBAction)renderMovieInSelection:(id)sender;

- (IBAction)appendSegment:(id)sender;
- (IBAction)replaceSegment:(id)sender;
- (IBAction)removeSegment:(id)sender;
- (IBAction)insertSegmentBefore:(id)sender;
- (IBAction)insertSegmentAfter:(id)sender;

- (IBAction)insertTransitionAfter:(id)sender;
- (IBAction)insertTransitionBefore:(id)sender;

- (IBAction)insertRegularLayer:(id)sender;
- (IBAction)insertMovieLayer:(id)sender;
- (IBAction)insertAnimationLayer:(id)sender;
- (IBAction)removeLayer:(id)sender;

- (IBAction)saveDocument:(id)sender;
- (IBAction)saveDocumentAs:(id)sender;
@end
