	.list ON, EXP
	
; Initializations for fig-FORTH for SH-3
; Joel Matthew Rees, Hyougo Polytec Center
; 2014.02.28

; Licensed extended under GPL v. 2 or 3, or per the following:
; ------------------------------------LICENSE-------------------------------------
;
; Copyright (c) 2009, 2010, 2011 Joel Matthew Rees
;
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
;
; The above copyright notice and this permission notice shall be included in
; all copies or substantial portions of the Software.
;
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
; THE SOFTWARE.
;
; --------------------------------END-OF-LICENSE----------------------------------


; Monolithic, not separate assembly:
; context.inc must be included before this file.
;	.include	"context.inc"
;
;	.section	initialize, code


; +ORIGIN ( n --- adr )
;         Calculate the address of the nth byte (n/NATURAL_WIDTH-th) entry 
;         in the boot-up parameter table.  
;         (Adds the base of the boot-up table to n.)
;
;         Use this to access the boot-up parameters after we are running.
;
	HIHEADER	"+ORIGIN", PORIG, DOCOL
	.data.l	LIT,ORIG,PLUS
	.data.l	SEMIS


	HEADER	COLD, CENT
; WENT will also move, eventually.
_fWENT:
	mov.l	#PER_USER, fUP
;
; Eventually want to initialize these from the COLD_PARAMETERS table --
;
	mov.l	#fSP_BASE, fSP
	mov.l	fSP, @(XSPZER, fUP)
	mov.l	#fRP_BASE, fRP
	mov.l	fRP, @(XRZERO, fUP)
;
	mov 	#0, r0
	mov.l	r0, @(XOUT,fUP)	; clear EMIT count.
;
	mov.l	#TEST_THINGY, fIP
	mov.l	#NEXT, r0
	jmp 	@r0
	nop



;COLD	FDB	*+2
;CENT	LDS	#REND-1	top of destination
;	LDX	#ERAM	top of stuff to move
;COLD2	DEX
;	LDA A	0,X
;	PSH A		move TASK & FORTH to ram
;	CPX	#RAM
;	BNE	COLD2
;*
;	LDS	#XFENCE-1	put stack at a safe place for now
;	LDX	COLINT
;	STX	XCOLUM
;	LDX	DELINT
;	STX	XDELAY
;	LDX	VOCINT
;	STX	XVOCL
;	LDX	DPINIT
;	STX	XDP
;	LDX	FENCIN
;	STX	XFENCE
;
;
;WENT	LDS	#XFENCE-1	top of destination
;	LDX	#FENCIN		top of stuff to move
;WARM2	DEX
;	LDA A	0,X
;	PSH A
;	CPX	#SINIT
;	BNE	WARM2
;*
;	LDS	SINIT
;	LDX	UPINIT
;	STX	UP		init user ram pointer
;	LDX	#ABORT
;	STX	IP
;	NOP		Here is a place to jump to special user
;	NOP		initializations such as I/0 interrups
;	NOP
;*
;* For systems with TRACE:
;	LDX	#00
;	STX	TRLIM	clear trace mode
;	LDX	#0
;	STX	BRKPT	clear breakpoint address
;	JMP	RPSTOR+2 start the virtual machine running !
;*
;* Here is the stuff that gets copied to ram :
;* at address $140:
;*
;* Thus, MAGIC numbers that initialize USE and PREV, magically! (JMR)
;* RAM	FDB	$3000,$3000,0,0
;RAM	FDB	$4000+132,$4000+132,0,0
;	




