unit Y_TextConverter;

{
	Yoffy's Text Converter
	from http://www6.tok2.com/home2/Yoffy/index.shtml
}

interface

// EUCSJIS֕ϊ
function EUCtoSJIS(
	v : string
) : string;

// SJISEUC֕ϊ
function	SJIStoEUC(
	v : string
) : string;

implementation

// EUCSJISւ1ϊ
procedure	euc2sjis( var h : Byte; var l : Byte ); Register;
begin

	if ( h and 1 ) <> 0 then
		l := l - $61
	else
		l := l - $03;
	if l >= $7f then
		Inc( l );
	h := ((h - $a1) shr 1) + $81;
	if h > $9f then
		h := h + $40;

end;

// SJISEUCւ1ϊ
procedure	sjis2euc( var h : Byte; var l : Byte ); Register;
begin

	if h <= $9f then
		h := h - $31
	else
		h := h - $71;
	h := (h shl 1) + 1;
	if l > $7f then
		Dec( l );
	if l >= $9e then begin
		l := l + 3;
		Inc( h );
	end else begin
		l := l + $61;
	end;

end;

// EUCSJIS֕ϊ
function EUCtoSJIS(
	v : string
) : string;
var
	src : PChar;
	bound : PChar;
	h, l : Byte;
	dst : PChar;
	dstMax, dstLen : Integer;
const
	kSO = $0E;
	kSI = $0F;
	kSS2 = $8E;
	kSS3 = $8F;
	BLOCK_SIZE = 10240;
	MARGIN = 5;
begin

	src := PChar( v );
	bound := src + Length( v );
	dstLen := 0;
	dstMax := BLOCK_SIZE;
	GetMem( dst, dstMax );
	dstMax := dstMax - MARGIN; // rɖ]ȃTCY𑫂ȂĂ悤

	while src < bound do begin
		if dstMax < dstLen then begin
			dstMax := dstMax + MARGIN + BLOCK_SIZE;
			ReallocMem( dst, dstMax );
			dstMax := dstMax - MARGIN;
		end;

		// ݊
		if Byte(Byte( src^ ) - $a1) < $5e then begin
			// ϊ
			h := Byte( src^ ); Inc( src );
			l := Byte( src^ ); Inc( src );
			euc2sjis( h, l );
			dst[ dstLen ] := Char( h ); Inc( dstLen );
			dst[ dstLen ] := Char( l ); Inc( dstLen );
		end else if kSS2 = Byte( src^ ) then begin // ݔpJi
			Inc( src );
			dst[ dstLen ] := src^; Inc( dstLen ); Inc( src );
		end else if kSS3 = Byte( src^ ) then begin // ݕ⏕
			// SJIS ł͕\łȂ
			dst[ dstLen ] := '.'; Inc( dstLen );
			dst[ dstLen ] := '.'; Inc( dstLen );
			src := src + 2;
		end else begin
			dst[ dstLen ] := src^; Inc( dstLen ); Inc( src );
		end;
	end;

	dst[ dstLen ] := Char( $0 );
	Result := string( dst );
	FreeMem( dst );

end;

//Result := ( (signed)(uint8_t)( ((uint8_t)(ch) ^ 0x20) - 0xa1 ) - 0x3c ) >> 31;
function	issjis_( ch : Longword ) : Boolean; Register;
asm
	xor	eax, $20
	sub	al, $a1
	cmp	eax, $3c
	sbb	eax, eax
end;

//#define iskana_(c) ((unsigned char)(c) > 0xa0 && (unsigned char)(c) < 0xe0)
function	iskana_( ch : Longword ) : Boolean; Register;
asm
	sub	al, $a1
	cmp	eax, $3f
	sbb	eax, eax
end;


// SJISEUC֕ϊ
function	SJIStoEUC(
	v : string
) : string;
var
	src : PChar;
	bound : PChar;
	h, l : Byte;
	dst : PChar;
	dstMax, dstLen : Integer;
const
	BLOCK_SIZE = 10240;
	MARGIN = 2;
begin

	src := PChar( v );
	bound := src + Length( v );
	dstLen := 0;
	dstMax := BLOCK_SIZE;
	GetMem( dst, dstMax );
	dstMax := dstMax - MARGIN; // rɖ]ȃTCY𑫂ȂĂ悤

	while src < bound do begin
		if dstMax < dstLen then begin
			dstMax := dstMax + MARGIN + BLOCK_SIZE;
			ReallocMem( dst, dstMax );
			dstMax := dstMax - MARGIN;
		end;

		if issjis_( Longword( src^ ) ) then begin
			h := Byte( src^ ); Inc( src );
			l := Byte( src^ ); Inc( src );
			sjis2euc( h, l );
			dst[ dstLen ] := Char( h ); Inc( dstLen );
			dst[ dstLen ] := Char( l ); Inc( dstLen );
		end else if iskana_( Longword( src^ ) ) then begin
			dst[ dstLen ] := Char( $8e ); Inc( dstLen );
			dst[ dstLen ] := src^; Inc( dstLen ); Inc( src );
		end else begin
			dst[ dstLen ] := src^; Inc( dstLen ); inc( src );
		end;
	end;

	dst[ dstLen ] := Char( $0 );
	Result := string( dst );
	FreeMem( dst );

end;

end.
