unit AbonUnit;

interface
uses
    Windows,Messages, ShellAPI, SysUtils, Classes,StdCtrls,StrUtils;

type
  TIndiviAbon = record
  	Res: Integer;
    option: Integer; // 0: 1:ʏ킠ځ[
  end;

  TAbon = class(TObject)
  private
    { Private 錾 }
    Froot : String;
    Flistpath : String;
    FNGwordpath : String;
    Ftokens : array of array of string;
    FAbonRes : array of TIndiviAbon;
    FAbonString : String;
//    FCutoffNum : Integer; //̐ȏA铯pNG[hƂ
    FDeleterlo : Boolean; //&rlo;邩 //ǉ&lro;
    FReplaceul :Boolean ; //<ul>^O<br>^Oɒu邩
    FReverse : Boolean ;  //NG[hł̂ځ`̌ʂ𔽓]邩
    FAbonPopupRes : Boolean; //X|bvAbv̎ɂځ[񂷂邩
    FCreateNGwordFile : Boolean; //w肳ꂽpathNG[htxtƂɎIɐ邩
    FNGwordFileIndex : Integer; //ݓǂݍłNG[hlist̉sڂ
    FNGwordname : String; //ݓǂݍłNG[h̕\
    FIndividualFileName : String;	//ʂځ`̃t@C
    FReturnNGwordLineNum : Boolean;	//NG[h̍sԂB
    FSetNGResAnchor : Boolean; //NGɊYƂɖ{ɂ̃Xւ̃XAJ[邩ǂ
    FDeleteSyria: Boolean;	//VAuN΍i&#1792~&#1871j
    procedure SetTokens(index: integer ; argline:String);
    function Getlistpath() : String;
    procedure Setlistpath(const Value : String);
    function LoadListFile(path :String;listStringList : TStringList) : Boolean;
    function ReadNGwordslist(line : Integer) : Boolean;
    function LoadFromSetResNumFile(SetResNumFile : String) : Boolean;
  public
    { Public 錾 }
    constructor Create; // RXgN^
    destructor Destroy; override; // fXgN^
    property Deleterlo: Boolean read FDeleterlo write FDeleterlo  default false;
    property Replaceul: Boolean read FReplaceul write FReplaceul  default false;
    property Reverse: Boolean read FReverse write FReverse  default false;
    property CreateNGwordFile: Boolean read FCreateNGwordFile write FCreateNGwordFile;
    property AbonString : String read FAbonString write FAbonString;
    property  AbonPopupRes : Boolean read FAbonPopupRes write FAbonPopupRes default false;
    property listpath : String read Getlistpath write Setlistpath;
    property NGwordFileIndex : Integer read FNGwordFileIndex write FNGwordFileIndex default 0;
    property NGwordname : String read FNGwordname write FNGwordname;
	property ReturnNGwordLineNum : Boolean read FReturnNGwordLineNum write FReturnNGwordLineNum default false;
    property SetNGResAnchor : Boolean read FSetNGResAnchor write FSetNGResAnchor default false;
    property DeleteSyria : Boolean read FDeleteSyria write FDeleteSyria default false;
    procedure Setroot(root :String);
    function Getroot() : String;

    function Getfullpath(argpath : String) : String;
    procedure SetNGwordpath(path :String);
    function GetNGwordpath() : String;
    function LoadFromNGwordFile(path :String) : Boolean;
    function ReLoadFromNGwordFile() : Boolean;
    procedure LoadFromStringList( bufstl : TStringList );
    function CheckAbonPopupRes(line : String) :Boolean;
	function FindNGwords(const line : String; var NGwordsLineNum : Integer; var Invisible : Boolean) : Boolean;//1CpB
	function FindNGwordsEx(const line : String; var NGwordsLineNum : Integer; var Invisible : Boolean) : Boolean;//1CpB
	//ځ`񏈗(NG[hł̃tB^O)
	procedure Execute(var ThreadStrings : TStringList); overload;
	procedure Execute(var ThreadStrings : TStringList; NGwords : TStringList); overload;
	procedure Execute(var ThreadStrings : TStringList; NGwords : TStrings); overload;
	procedure Execute(var ResString : String; ResNumber : Integer); overload;	//pluginDat To HTML p
	procedure ExecuteEx(var ThreadStrings : TStringList); overload;
	procedure ExecuteEx(var ThreadStrings : TStringList; NGwords : TStringList); overload;
	procedure ExecuteEx(var ThreadStrings : TStringList; NGwords : TStrings); overload;
	procedure ExecuteEx(var ResString : String; ResNumber : Integer); overload;	//pluginDat To HTML p

	//ʂځ`񂵂
	procedure IndividualAbon(var ThreadStrings : TStringList; SetResNumFile : String); overload;
	procedure IndividualAbon(var ResString : String; SetResNumFile : String; ResNumber : Integer); overload;
	procedure AddIndividualAbon( ResNum : Integer ; option : Integer);
	procedure DeleteIndividualAbon( ResNum : Integer);
	function GetAbonResCount() : Integer;
	function GetAbonResString(Num : Integer) : String;
	function CheckIndividualAbonList(ResNum : Integer) : Boolean;

	procedure EditNGwords();  //NGword.txtJB
	function ShowAllTokens() : String;  //fobOp
	//--
	procedure GoHome();//List̂Psڂǂ
	function GoForward() : Boolean; //LisẗNG[ht@Cǂݍ
	function GoBack() : Boolean; //LisẗONG[ht@Cǂݍ
	//--
	function TreatSyria(AString: string): string;
  end;
var
	Abon1 :TAbon;
const
	NGwordListFileName : String = 'NGwords.list';

implementation

uses MojuUtils;

constructor TAbon.Create;
begin
	// 
	FAbonString := '&nbsp;<>&nbsp;<>&nbsp;<>&nbsp;&nbsp;<><>';
	FCreateNGwordFile := true;
	SetLength(FAbonRes,1);
	FAbonRes[0].Res := 0;
	FAbonRes[0].option := -1;

end;

destructor TAbon.Destroy;
begin
	inherited;
end;
//rootExe\config\NGwordstH_
procedure TAbon.Setroot(root :String);
var
	bufStringList : TStringList;
begin
	bufStringList := TStringList.Create;
	try
		if not DirectoryExists(root) then begin
			CreateDir(root);
		end;
		if root[Length(root)] <> '\' then begin
			root := root + '\';
		end;
		Flistpath := root + NGwordListFileName;
		LoadListFile(Flistpath, bufStringList);
	finally
		bufStringList.Free;
	end;
	Froot := root;
end;
function TAbon.Getroot() : String;
begin
	Result := Froot;
end;
//NGwordpathNGword.txt̃tpX
procedure TAbon.SetNGwordpath(path :String);
begin
	FNGwordpath := Getfullpath(path);
	LoadFromNGwordFile(FNGwordpath);
end;
function TAbon.GetNGwordpath() : String;
begin
	Result :=  FNGwordpath;
end;
//tpXłȂ΃tpXɂĕԂB
function TAbon.Getfullpath(argpath : String) : String;
begin
	if AnsiPos(':\',argpath) <> 2 then begin  //hCũtpX
		if Getroot() = '' then begin
			Result := '';    //rootpXݒ肳ĂȂɂ
		end else begin
			if (Froot[Length(Froot)] = '\') and (argpath[1] = '\') then begin  //擪\폜
				Delete(argpath,1,1);
			end;
			Insert( Getroot(), argpath , 1);//rootpX}
			Result := argpath;
		end;
	end else begin
		Result := argpath;
	end;

end;
//NGwordt@C̓ǂݍ
function TAbon.LoadFromNGwordFile(path :String) : boolean;
var
	bufstl : TStringList;
begin
	path := Getfullpath(path);
	if path = '' then begin
		Result := false;
	end else begin
		bufstl := TStringList.Create;
		try
			try
				bufstl.LoadFromFile(path);
				LoadFromStringList( bufstl );
				Result := true;
			except
				if CreateNGwordFile = true then begin
					bufstl.SaveToFile(path);
				end;
				Result := false;
			end;
		finally
			bufstl.Free;
		end;
	end;

end;
//NGwordXgǂݍ
procedure TAbon.LoadFromStringList( bufstl : TStringList );
var
	i : integer;
begin
	try
		for i := bufstl.Count -1  downto 0 do begin
			if bufstl.Strings[i] = '' then begin
				bufstl.Delete(i);
			end;
		end;
		SetLength(Ftokens,bufstl.Count);
		for i := 0  to bufstl.Count -1 do begin
			SetTokens(i , bufstl.Strings[i]);
		end;

	except
		Exit;
	end;
end;
//NGwordpathɐݒ肳ĂƂ̃[hp֐
function TAbon.ReLoadFromNGwordFile() : boolean;
begin
	if GetNGwordpath() ='' then begin
		Result := false;
	end else begin
		Result := LoadFromNGwordFile( GetNGwordpath() );
	end;
end;
function TAbon.Getlistpath() : String;
begin
	Result := Flistpath;
end;
procedure TAbon.Setlistpath(const Value : String);
begin
	Flistpath := Getfullpath(Value);
end;
//s̒̃g[N؂蕪ăZbg
procedure TAbon.SetTokens(index: integer ; argline : String);
var
	ret : Integer;
	bufstl : TStringList;
	i : Integer;
	pos : Integer;
	buftoken : String;
begin
	pos := 0;
	bufstl := TStringList.Create;
	try
		if Length(argline) > 0 then begin
			pos := AnsiPos(#9,argline);
			while pos <> 0 DO begin
				buftoken := Copy(argline,1,pos-1);
				Delete(argline,1,pos);
				if Length(buftoken) > 0 then begin
					bufstl.Append(buftoken);
				end else if ( bufstl.Count = 0 ) then begin
					bufstl.Append('');
				end;
				pos := AnsiPos(#9,argline);
			end;
			if Length(argline) > 0 then begin
				bufstl.Append(argline);
			end;
			ret := bufstl.Count;
			SetLength(Ftokens[index],ret);
			for i := 0 to bufstl.Count - 1  do begin
				Ftokens[index][i] := bufstl.Strings[i];
			end;
		end;
	finally
		bufstl.Free;
	end;

end;
//DebugpNG[hEĂ邩
function TAbon.ShowAllTokens() : String;
var
	i : Integer;
	j : Integer;
	ret : String;
begin
	for i := 0 to High(Ftokens) do begin
		for j := 0 to High(Ftokens[i]) do begin
			ret := ret + Ftokens[i][j];
		end;
	end;
	Result := ret;



end;
//NG[h܂܂ĂtrueԂANG[h̍sNGwordsLineNumɓĕԂB
//ځ`ɂȂInbisibletrueɂĕԂ
function TAbon.FindNGwords(const line : String; var NGwordsLineNum : Integer; var Invisible : Boolean) : Boolean; //1CpB
var
	lines : Integer;
	cells : Integer;
	hit : Boolean;
	bufline : String;
	start : Integer;
begin
	hit := false;
	if AnsiPos(FAbonString,line) <> 1 then begin
		for lines := 0 to High(Ftokens) do begin
			hit := true;
			bufline := line;
			if Ftokens[lines][0] <> ''  then begin
				Invisible := false;
				start := 0;
			end else begin
				Invisible := true;
				start := 1;
			end;

			for cells := start to High(Ftokens[lines]) do begin
				if AnsiPos(Ftokens[lines][cells],bufline) = 0 then begin
					hit := false;
					break;
				end else begin
					Delete(bufline,AnsiPos(Ftokens[lines][cells],bufline),Length(Ftokens[lines][cells]));
				end;
			end;
			if hit = true then begin
				NGwordsLineNum := lines + 1;
				break;
			end;
		end;
	end;
	Result := hit;
end;
//NG[h܂܂ĂtrueԂANG[h̍sNGwordsLineNumɓĕԂB
//ځ`ɂȂInbisibletrueɂĕԂ
//pSp
function TAbon.FindNGwordsEx(const line : String; var NGwordsLineNum : Integer; var Invisible : Boolean) : Boolean;//1CpB
var
	lines : Integer;
	cells : Integer;
	hit : Boolean;
	bufline : String;
	start : Integer;
begin
	hit := false;
	if AnsiPos(FAbonString,line) <> 1 then begin
		for lines := 0 to High(Ftokens) do begin
			hit := true;
			bufline := line;
			if Ftokens[lines][0] <> ''  then begin
				Invisible := false;
				start := 0;
			end else begin
				Invisible := true;
				start := 1;
			end;

			for cells := start to High(Ftokens[lines]) do begin
				if AnsiPos(Ftokens[lines][cells],bufline) = 0 then begin
					hit := false;
					break;
				end else begin
					Delete(bufline, AnsiPos(Ftokens[lines][cells],bufline),Length(Ftokens[lines][cells]));
				end;
			end;
			if hit = true then begin
				NGwordsLineNum := lines + 1;
				break;
			end;
		end;
	end;
	Result := hit;
end;
//̃u[ltrueƁANG[h܂ނ̂ԂB
procedure TAbon.Execute(var ThreadStrings : TStringList);
var
	i : Integer;
	NGwordsLine : Integer;
	bufline : String;
	invisi : Boolean;
begin
	for i:=0 to ThreadStrings.Count - 1 do begin
		NGwordsLine := 0;
		if FindNGwords(ThreadStrings.Strings[i], NGwordsLine ,invisi) <> Reverse  then begin
			if invisi = true then begin
				ThreadStrings.Strings[i] := '';
			end else begin
				if not ReturnNGwordLineNum and not SetNGResAnchor then begin
					ThreadStrings.Strings[i] := FAbonString;
				end else if not ReturnNGwordLineNum then begin
					ThreadStrings.Strings[i] := Format('&nbsp;<>&nbsp;<>&nbsp;<>&gt;%d<><>',[(i+1)]);
				end else if not SetNGResAnchor then begin
					ThreadStrings.Strings[i] := Format('&nbsp;<>&nbsp;<>&nbsp;<><B> %d sڂNG[h܂܂Ă܂B</B><><>',[NGwordsLine]);
				end else begin
					ThreadStrings.Strings[i] := Format('&nbsp;<>&nbsp;<>&nbsp;<><B> %d sڂNG[h܂܂Ă܂B</B>&gt;%d <><>',[NGwordsLine,(i+1)]);
				end;
			end;
		end else begin
			bufline := ThreadStrings.Strings[i];
			if Deleterlo = true then begin
				bufline := CustomStringReplace(bufline,'&rlo;','');
				bufline := CustomStringReplace(bufline,'&lro;','');
			end;
			if Replaceul = true then begin
				bufline := CustomStringReplace( bufline,'<ul>','<br>' );
				bufline := CustomStringReplace( bufline,'</ul>','<br>' );
			end;
			if DeleteSyria = true then
				bufline := TreatSyria(bufline);
			ThreadStrings.Strings[i] := bufline;
		end;
	end;
end;
procedure TAbon.Execute(var ResString : String; ResNumber : Integer);
var
	NGwordsLine : Integer;
	bufline : String;
	invisi : Boolean;
begin
	NGwordsLine := 0;
	if FindNGwords(ResString, NGwordsLine ,invisi) <> Reverse  then begin
		if invisi = true then begin
			ResString := '';
		end else begin
			if not ReturnNGwordLineNum and not SetNGResAnchor then begin
				ResString := FAbonString;
			end else if not ReturnNGwordLineNum then begin
				ResString := Format('&nbsp;<>&nbsp;<>&nbsp;<>&gt;%d<><>',[(ResNumber)]);
			end else if not SetNGResAnchor then begin
				ResString := Format('&nbsp;<>&nbsp;<>&nbsp;<><B> %d sڂNG[h܂܂Ă܂B</B><><>',[NGwordsLine]);
			end else begin
				ResString := Format('&nbsp;<>&nbsp;<>&nbsp;<><B> %d sڂNG[h܂܂Ă܂B</B>&gt;%d <><>',[NGwordsLine,(ResNumber)]);
			end;
		end;
	end else begin
		bufline := ResString;
		if Deleterlo = true then begin
			bufline := CustomStringReplace( bufline,'&rlo;','' );
			bufline := CustomStringReplace( bufline,'&lro;','' );
		end;
		if Replaceul = true then begin
			bufline := CustomStringReplace( bufline,'<ul>','<br>' );
			bufline := CustomStringReplace( bufline,'</ul>','<br>' );
		end;
		if DeleteSyria = true then
			bufline := TreatSyria(bufline);
		ResString := bufline;
	end;
end;

procedure TAbon.Execute(var ThreadStrings : TStringList; NGwords : TStringList);
var
	i : Integer;
begin
	SetLength(Ftokens,NGwords.Count);
	for i := 0  to NGwords.Count -1 do begin
		SetTokens(i , NGwords.Strings[i]);
	end;
	Execute(ThreadStrings);

end;
procedure TAbon.Execute(var ThreadStrings : TStringList; NGwords : TStrings);
var
	i : Integer;
	buf : TStringList;
begin
	buf := TStringList.Create;
	buf.AddStrings(NGwords);
	SetLength(Ftokens,buf.Count);
	for i := 0  to buf.Count -1 do begin
		SetTokens(i , buf.Strings[i]);
	end;
	Execute(ThreadStrings);
	buf.Free;
end;

//̃u[ltrueƁANG[h܂ނ̂ԂB
procedure TAbon.ExecuteEx(var ThreadStrings : TStringList);
var
	i : Integer;
	NGwordsLine : Integer;
	bufline : String;
	invisi : Boolean;
begin
	for i:=0 to ThreadStrings.Count - 1 do begin
		NGwordsLine := 0;
		if FindNGwordsEx(ThreadStrings.Strings[i], NGwordsLine ,invisi) <> Reverse  then begin
			if invisi = true then begin
				ThreadStrings.Strings[i] := '';
			end else begin
				if not ReturnNGwordLineNum and not SetNGResAnchor then begin
					ThreadStrings.Strings[i] := FAbonString;
				end else if not ReturnNGwordLineNum then begin
					ThreadStrings.Strings[i] := Format('&nbsp;<>&nbsp;<>&nbsp;<>&gt;%d<><>',[(i+1)]);
				end else if not SetNGResAnchor then begin
					ThreadStrings.Strings[i] := Format('&nbsp;<>&nbsp;<>&nbsp;<><B> %d sڂNG[h܂܂Ă܂B</B><><>',[NGwordsLine]);
				end else begin
					ThreadStrings.Strings[i] := Format('&nbsp;<>&nbsp;<>&nbsp;<><B> %d sڂNG[h܂܂Ă܂B</B>&gt;%d <><>',[NGwordsLine,(i+1)]);
				end;
			end;
		end else begin
			bufline := ThreadStrings.Strings[i];
			if Deleterlo = true then begin
				bufline := CustomStringReplace(bufline,'&rlo;','');
				bufline := CustomStringReplace(bufline,'&lro;','');
			end;
			if Replaceul = true then begin
				bufline := CustomStringReplace( bufline,'<ul>','<br>' );
				bufline := CustomStringReplace( bufline,'</ul>','<br>' );
			end;
			if DeleteSyria = true then
				bufline := TreatSyria(bufline);
			ThreadStrings.Strings[i] := bufline;
		end;
	end;
end;
procedure TAbon.ExecuteEx(var ResString : String; ResNumber : Integer);
var
	NGwordsLine : Integer;
	bufline : String;
	invisi : Boolean;
begin
	NGwordsLine := 0;
	if FindNGwordsEx(ResString, NGwordsLine ,invisi) <> Reverse  then begin
		if invisi = true then begin
			ResString := '';
		end else begin
			if not ReturnNGwordLineNum and not SetNGResAnchor then begin
				ResString := FAbonString;
			end else if not ReturnNGwordLineNum then begin
				ResString := Format('&nbsp;<>&nbsp;<>&nbsp;<>&gt;%d<><>',[(ResNumber)]);
			end else if not SetNGResAnchor then begin
				ResString := Format('&nbsp;<>&nbsp;<>&nbsp;<><B> %d sڂNG[h܂܂Ă܂B</B><><>',[NGwordsLine]);
			end else begin
				ResString := Format('&nbsp;<>&nbsp;<>&nbsp;<><B> %d sڂNG[h܂܂Ă܂B</B>&gt;%d <><>',[NGwordsLine,(ResNumber)]);
			end;
		end;
	end else begin
		bufline := ResString;
		if Deleterlo = true then begin
			bufline := CustomStringReplace( bufline,'&rlo;','' );
			bufline := CustomStringReplace( bufline,'&lro;','' );
		end;
		if Replaceul = true then begin
			bufline := CustomStringReplace( bufline,'<ul>','<br>' );
			bufline := CustomStringReplace( bufline,'</ul>','<br>' );
		end;
		if DeleteSyria = true then
			bufline := TreatSyria(bufline);
		ResString := bufline;
	end;
end;

procedure TAbon.ExecuteEx(var ThreadStrings : TStringList; NGwords : TStringList);
var
	i : Integer;
begin
	SetLength(Ftokens,NGwords.Count);
	for i := 0  to NGwords.Count -1 do begin
		SetTokens(i , NGwords.Strings[i]);
	end;
	ExecuteEx(ThreadStrings);

end;
procedure TAbon.ExecuteEx(var ThreadStrings : TStringList; NGwords : TStrings);
var
	i : Integer;
	buf : TStringList;
begin
	buf := TStringList.Create;
	buf.AddStrings(NGwords);
	SetLength(Ftokens,buf.Count);
	for i := 0  to buf.Count -1 do begin
		SetTokens(i , buf.Strings[i]);
	end;
	ExecuteEx(ThreadStrings);
	buf.Free;
end;

//****************************************************************************//
//݃ZbgĂNGword.txtJ
procedure TAbon.EditNGwords();
begin
	ShellExecute(0 ,nil,PChar(FNGwordpath),nil,nil,SW_SHOW);
end;
//|bvAbvp֐
function TAbon.CheckAbonPopupRes(line : String) :Boolean;
var
	i: Integer;
	v: boolean;
begin
	if AbonPopupRes = true then begin
		Result := FindNGwords(line, i ,v);
	end else begin
		Result := false;
	end;
end;
//NG[heLXgǂݍ==============================================
//Listt@Cǂݍ
function TAbon.LoadListFile(path :String; listStringList : TStringList) : Boolean;
begin
    try
        listStringList.LoadFromFile(path);
        Result := true;
    except
        listStringList.Append('=NGword.txt');
        listStringList.SaveToFile(path);
        Result := false;
    end;
end;
//LisẗNG[ht@Cǂݍ
function TAbon.GoForward() : Boolean;
begin
    FNGwordFileIndex := FNGwordFileIndex + 1;
    Result := ReadNGwordslist(FNGwordFileIndex);
end;
//LisẗONG[ht@Cǂݍ
function TAbon.GoBack() : Boolean;
begin
    FNGwordFileIndex := FNGwordFileIndex -1;
    Result := ReadNGwordslist(FNGwordFileIndex);
end;
//List̂Psڂǂ
procedure TAbon.GoHome();
begin
    FNGwordFileIndex := 0;
    ReadNGwordslist(FNGwordFileIndex);
end;
//Listlinesڂǂ
function TAbon.ReadNGwordslist(line : Integer) : Boolean;
var
    liststl : TStringList;
    linebuf : String;
begin
    liststl := TStringList.Create;
    try
        if LoadListFile(Flistpath,liststl) = true then begin
            if line < 0 then begin
                line := liststl.Count - 1;
                FNGwordFileIndex := liststl.Count - 1;
            end else if line > liststl.Count - 1 then begin
                line := 0;
                FNGwordFileIndex := 0;
            end;
            linebuf := liststl.Strings[line];
            FNGwordname := Copy(linebuf,1,AnsiPos('=',linebuf)-1);
            Delete(linebuf,1,AnsiPos('=',linebuf));
            SetNGwordpath(linebuf);
            Result := true;
        end else begin
            Result := false;
        end
    finally
        liststl.Free;
    end;

end;
//NG[heLXgǂݍ=====܂=================================
//ʂځ`s֐
procedure TAbon.IndividualAbon(var ThreadStrings : TStringList; SetResNumFile : String);
var
	i : Integer;
begin
	if FileExists(SetResNumFile) = true then begin
    	if LoadFromSetResNumFile(SetResNumFile) = true then begin
        	for i := 0 to High(FAbonRes) do begin
                 if (FAbonRes[i].Res <= ThreadStrings.Count) and (FAbonRes[i].Res > 0) then begin
            	 	if FAbonRes[i].option = 0 then begin
                    	ThreadStrings.Strings[FAbonRes[i].Res-1] := '';
                    end else begin
                        ThreadStrings.Strings[FAbonRes[i].Res-1] := 'ځ`<>ځ`<>ځ`<>ځ`<>';
                    end;
                 end;

            end;
        end;
    end else begin
        FIndividualFileName := SetResNumFile;
    	SetLength(FAbonRes,1);
        FAbonRes[0].Res := 0;
        FAbonRes[0].option := -1;
    end;
end;
procedure TAbon.IndividualAbon(var ResString : String; SetResNumFile : String; ResNumber : Integer);
var
	i : Integer;
begin
	if FileExists(SetResNumFile) = true then begin
    	if LoadFromSetResNumFile(SetResNumFile) = true then begin
        	for i := 0 to High(FAbonRes) do begin
                 if FAbonRes[i].Res = ResNumber then begin
                 	if FAbonRes[i].option = 0 then begin
                    	ResString := '';
                    end else begin
                        ResString := 'ځ`<>ځ`<>ځ`<>ځ`<>';
                    end;
                    Exit;
                 end;
            end;
        end;
    end else begin
        FIndividualFileName := SetResNumFile;
    	SetLength(FAbonRes,1);
        FAbonRes[0].Res := 0;
        FAbonRes[0].option := -1;
    end;
end;

//ʂځ`t@Cǂݍ݊֐
function TAbon.LoadFromSetResNumFile(SetResNumFile : String) : Boolean;
var
	bufStringList : TStringList;
    bufLine : String;
    i : Integer;
begin
    bufStringList := TStringList.Create;
    try
        try
	    	bufStringList.LoadFromFile(SetResNumFile);
            FIndividualFileName := SetResNumFile;
            //s폜
    	    for i := bufStringList.Count-1 downto 0 do begin
        		if bufStringList.Strings[i] = '' then begin
            		bufStringList.Delete(i);
	            end;
    	    end;

            //m
	        SetLength(FAbonRes,bufStringList.Count);
            //
    	    for i :=0 to bufStringList.Count - 1 do begin
        		bufLine := Trim(bufStringList.Strings[i]);
	            FAbonRes[i].Res :=  StrToInt(Copy(bufLine,1,AnsiPos('-',bufLine)-1));
                FAbonRes[i].option := StrToInt(Copy(bufLine,AnsiPos('-',bufLine)+1,1));
    	    end;
        except
        	Result := false;
            Exit;
        end;
    finally
    	bufStringList.Free;
    end;
    Result := true;
end;
//ʂځ`t@Cɒǉ
procedure TAbon.AddIndividualAbon( ResNum : Integer ; option : Integer);
var
	IndividualFile : TStringList;
    linebuf : String;
    i : Integer;
begin
    IndividualFile := TStringList.Create;
	if FAbonRes[0].Res <> 0 then begin
        for i := 0 to High(FAbonRes) do begin
            if FAbonRes[i].Res <> ResNum then begin
    			linebuf := IntToStr(FAbonRes[i].Res) + '-' + IntToStr(FabonRes[i].option);
            	IndividualFile.Append(linebuf);
            end;
        end;
    end;
    linebuf := IntToStr(ResNum) + '-' + IntToStr(option);
    IndividualFile.Append(linebuf);
    try
    	IndividualFile.SaveToFile(FIndividualFileName);
    finally
        IndividualFile.Free;
    end;
end;
//ʂځ`t@C폜
procedure TAbon.DeleteIndividualAbon( ResNum : Integer);
var
	IndividualFile : TStringList;
    linebuf : String;
    i : Integer;
begin
    IndividualFile := TStringList.Create;
	if FAbonRes[0].Res <> 0 then begin
        for i := 0 to High(FAbonRes) do begin
            if FAbonRes[i].Res <> ResNum then begin
    			linebuf := IntToStr(FAbonRes[i].Res) + '-' + IntToStr(FabonRes[i].option);
            	IndividualFile.Append(linebuf);
            end;
        end;
    end;
	if IndividualFile.Count <> 0 then begin
    	try
    		IndividualFile.SaveToFile(FIndividualFileName);
    	finally
        	IndividualFile.Free;
    	end;
    end else begin
    	if FileExists(FIndividualFileName) = true then begin
        	DeleteFile(FIndividualFileName);
        end;
    end;
end;
//ʂځ`̃XǧԂ
function TAbon.GetAbonResCount() : Integer;
var
	i : Integer;
begin
    if FAbonRes[0].Res = 0 then begin
    	Result := 0
    end else begin
		i := High(FAbonRes);
        Result := i+1;
    end;
end;
//ʂځ`̃Xĝsڂ̃X𕶎ŕԂ
function TAbon.GetAbonResString(Num : Integer) : String;
begin
	if (Num <= High(FAbonRes)) and (Num >= 0) then begin
    	Result := IntToStr(FAbonRes[Num].Res);
    end else begin
    	Result := '';
    end;
end;
//|bvAbv̔p
function TAbon.CheckIndividualAbonList(ResNum : Integer) : Boolean;
var
	i : Integer;
begin
	if FAbonRes[0].Res <> 0 then begin
    	for i := 0 to High(FAbonRes) do begin
        	if FAbonRes[i].Res = ResNum then begin
            	Result := true;
                Exit;
            end;
        end;
    end;
	Result := false;

end;
//VAuN΍
function TAbon.TreatSyria(AString: string): string;
var
	//count: Integer; //(&#1792~&#1871)
	pos: Integer;
	tmp: string;
begin
	pos := AnsiPos('&#18', AString);
	while pos <> 0  do begin
		if StrToIntDef(Copy(AString, pos+4, 2), -1) > 0 then begin
			if (AString[pos+6] = ';' )  or (AString[pos+6] = ' ') then begin
				tmp := tmp + Copy(AString, 1, pos - 1);
				Delete(AString, 1, pos+6);
			end else if StrToIntDef(AString[pos+6], -1) = -1 then begin
				tmp := tmp + Copy(AString, 1, pos - 1);
				Delete(AString, 1, pos+5);
			end else begin
				tmp := tmp + Copy(AString, 1, pos + 5);
				Delete(AString, 1, pos+5);
			end;
		end else begin
			tmp := tmp + Copy(AString, 1, pos + 5);
			Delete(AString, 1, pos+5);
		end;
		pos := AnsiPos('&#18', AString);
	end;
	if Length(AString) > 0 then
		tmp := tmp + AString;
	AString := tmp;
	tmp := '';

	pos := AnsiPos('&#179', AString);
	while pos <> 0 do begin
		if StrToIntDef(Copy(AString, pos+5, 1), 0) > 2 then begin
			if (AString[pos+6] = ';') or (AString[pos+6] = ' ') then begin
				tmp := tmp + Copy(AString, 1, pos - 1);
				Delete(AString, 1, pos+6);
			end else if StrToIntDef(AString[pos+6], -1) = -1 then begin
				tmp := tmp + Copy(AString, 1, pos - 1);
				Delete(AString, 1, pos+5);
			end else begin
				tmp := tmp + Copy(AString, 1, pos + 5);
				Delete(AString, 1, pos+5);
			end;
		end else begin
			tmp := tmp + Copy(AString, 1, pos + 5);
			Delete(AString, 1, pos+5);
		end;
		pos := AnsiPos('&#179', AString);
	end;
	if Length(AString) > 0 then
		tmp := tmp + AString;
	Result := tmp;
end;
end.

