unit GikoXMLDoc;

{
	XMLIntf, XMLDoc ̃N[
	Delphi 6 Personal p
}
interface

//==================================================
uses
//==================================================

	Classes, SysUtils, Windows,
	YofUtils;

//==================================================
type
//==================================================

	// 킯킩炸Ă邩oO炯
	XMLDictionary = Record
		Name : string;
		Value : string;
	end;

	IXMLNode = class
	private
		FNodeName : string;
		FCapacity : Integer;
		FCount : Integer;
		FAttributeCount : Integer;
		FChildNodes : IXMLNode;
		FNodes : array of IXMLNode;
		FAttributes : array of XMLDictionary;
		function GetAttribute( const Name : string ) : string;
		function GetNode( Index : Integer ) : IXMLNode;
	public
		constructor	Create;
		destructor	Destroy; override;

		property NodeName : string read FNodeName write FNodeName;
		property Attributes[ const Name : string ] : string read GetAttribute;
		property Node[ Index : Integer ] : IXMLNode read GetNode; default;
		property ChildNodes : IXMLNode read FChildNodes write FChildNodes;
		property Count : Integer read FCount write FCount;
		procedure Add( node : IXMLNode );
		procedure AddAttribute( const Name : string; const Value : string );
	end;

	IXMLDocument = class( IXMLNode )
	private
		function GetDocumentElement() : IXMLNode;
	public
		property DocumentElement : IXMLNode read GetDocumentElement;
	end;

function XMLCloseCheck(
	var p				: PChar;
	const tail	: PChar;
	var node : IXMLNode;
	out tag : string;
	out closed : boolean // Ăяo[` node ׂȂ true
) : boolean; // ch ̃[`Ȃ true

function XMLReadNode(
	var p				: PChar;
	const tail	: PChar;
	var node : IXMLNode
) : string; // node ȊÕm[hꂽꍇ̃m[h

procedure LoadXMLDocument(
	const fileName : string;
    var doc : IXMLDocument
);

//==================================================
const
//==================================================
	kXMLWhite : TSysCharSet = [#0..#$20];
	kXMLNodeNameStop : TSysCharSet = [#0..#$20, '/', '>'];
	kXMLAttributeNameStop : TSysCharSet = [#0..#$20, '=', '/', '>'];
	kXMLDQuote : TSysCharSet = ['"'];
	kXMLTagStart : TSysCharSet = ['<'];
	kXMLTagEnd : TSysCharSet = ['>'];
	kXMLKanji : TSysCharSet = [#$81..#$9f, #$E0..#$fc];

//==================================================
implementation
//==================================================

// Constructor
constructor	IXMLNode.Create;
begin

	inherited;

	FCapacity := 0;
	FCount := 0;

end;

// Destructor
destructor	IXMLNode.Destroy;
var
	i : Integer;
begin

	for i := FCount - 1 downto 0 do
		FNodes[ i ].Free;
	FChildNodes.Free;

	inherited;

end;

function IXMLNode.GetAttribute( const Name : string ) : string;
var
	i : Integer;
begin

	i := 0;
	while i < FAttributeCount do
	begin
		if Name = FAttributes[ i ].Name then
		begin
			Result := FAttributes[ i ].Value;
			exit;
		end;

		Inc( i );
	end;

end;

function IXMLNode.GetNode( Index : Integer ) : IXMLNode;
begin

	Result := FNodes[ Index ];

end;

procedure IXMLNode.Add( node : IXMLNode );
begin

	Inc( FCount );
	if FCount > FCapacity then begin
		FCapacity := FCapacity + (FCapacity shr 2) + 1;
		SetLength( FNodes, FCapacity );
	end;

	FNodes[ FCount - 1 ] := node;

end;

procedure IXMLNode.AddAttribute(
	const Name : string;
	const Value : string
);
var
	index : Integer;
begin

	index := FAttributeCount;
	Inc( FAttributeCount );
	SetLength( FAttributes, FAttributeCount );

	FAttributes[ index ].Name := Name;
	FAttributes[ index ].Value := Value;

end;

function IXMLDocument.GetDocumentElement() : IXMLNode;
begin

	Result := FChildNodes[ 0 ];

end;

{*!
\brief	tok T
\param	p			TJnʒu
\param	tail	Iʒu + 1
\param	tok		TLN^
\return	tok ŏɌʒu
*}
function AnsiStrTok(
	p			: PChar;
	const tail	: PChar;
	const tok : TSysCharSet
) : PChar;
begin

	while p < tail do
	begin
		if p^ in tok then
		begin
			Break;
		end else if p^ in kXMLKanji then
			p := p + 2
		else
			Inc( p );
	end;

	Result := p;

end;

{*!
\brief	tok ł͖LN^T
\param	p			TJnʒu
\param	tail	Iʒu + 1
\param	tok		TLN^
\return	tok ł͂ȂLN^ŏɌʒu
*}
function AnsiStrNonTok(
	p			: PChar;
	const tail	: PChar;
	const tok : TSysCharSet
) : PChar;
begin

	while p < tail do
	begin
		if p^ in tok then
		begin
			if p^ in kXMLKanji then
				p := p + 2
			else
				Inc( p );
		end else begin
			Break;
		end;
	end;

	Result := p;

end;

function XMLCloseCheck(
	var p : PChar;
	const tail	: PChar;
	var node : IXMLNode;
	out tag : string;
	out closed : boolean
) : boolean; // ch ̃[`Ȃ true
var
	found		: PChar;
begin

	closed := false;
	Result := false;
	tag := '';

	case p^ of
	'>':
		begin
			// Jn^O̍Ō܂œǂ
			Inc( p );	// '>' ΂
			Result := true;
		end;

	'?':
		begin
			// <?xml?> ݂ȂBĖ
			p := AnsiStrTok( p, tail, kXMLTagEnd );
			p := AnsiStrTok( p, tail, kXMLTagStart );
			Inc( p );	// '<' ΂
			p := AnsiStrNonTok( p, tail, kXMLWhite );
			//closed := true;
			Result := true;
		end;

	'/':
		begin
			// ^OǂݍŕԂ
			Inc( p );	// '/' ΂
			found := AnsiStrTok( p, tail, kXMLTagEnd );
//			tag := Copy( p, 0, found - p );	// ̂x
			SetLength( tag, found - p );
			CopyMemory( PChar( tag ), p, found - p );

			p := found + 1; // '>' ΂
			closed := true;
			Result := true;
		end;
	end;

end;

function XMLReadNode(
	var p : PChar;
	const tail	: PChar;
	var node : IXMLNode
) : string; // node ȊÕm[hꂽꍇ̃m[h
var
	child : IXMLNode;

	found : PChar;
	tag : string;

	isClosed : boolean;

	nodeName : string;
	attributeName : string;
	attributeValue : string;
label
	NextNode;
begin
	try
		// node ̓ǂݍ(1 [vɂ 1 m[h)
		node.ChildNodes := IXMLNode.Create;

		while p < tail do
		begin
			// NodeName ǂݍ
			p := AnsiStrNonTok( p, tail, kXMLWhite );

			while p < tail do
			begin
				if XMLCloseCheck( p, tail, node, tag, isClosed ) then
				begin
					if isClosed then
					begin
						Result := tag;
						exit;
					end;

					goto NextNode;
				end else if p^ = '<' then
				begin
					// VKm[h
					Inc( p );
					child := IXMLNode.Create;
					tag := XMLReadNode( p, tail, child );
					node.ChildNodes.Add( child );

					// ^Oꂽ
					if Length( tag ) > 0 then
					begin
						// ̂̂`FbNāAႦΐeɕԂ
						if tag <> node.NodeName then
							Result := tag;
						exit;
					end;

					goto NextNode;
				end else if p^ in kXMLWhite then
				begin
					// NodeName 
					break;
				end else begin
					found := AnsiStrTok( p, tail, kXMLNodeNameStop );
					SetLength( nodeName, found - p );
					CopyMemory( PChar( nodeName ), p, found - p );
					node.NodeName := nodeName;

					p := found;
				end;
			end;

			// Attribute ̓ǂݍ
			while p < tail do
			begin
				// Attribute ̖Oǂݍ
				attributeName := '';
				attributeValue := '';

				p := AnsiStrNonTok( p, tail, kXMLWhite );

				while p < tail do
				begin
					if XMLCloseCheck( p, tail, node, tag, isClosed ) then
					begin
						if isClosed then
						begin
							// ^Oꂽ̂Ń^[
							// NodeName ʉ߂Ă̂œrŕĂ邱ƂɂȂB
							// ēƗm[hB
							exit;
						end;

						// ̃m[h
						goto NextNode;
					end else if p^ = '=' then
					begin
						// ͒ln܂̂ŖO͏I
						Inc( p );
						break;
					end else if p^ in kXMLWhite then
					begin
						// Value ݂Ȃ(KiO)̂Ŏ̃m[h
						goto NextNode;
					end else begin
						found := AnsiStrTok( p, tail, kXMLAttributeNameStop );
						SetLength( attributeName, found - p );
						CopyMemory( PChar( attributeName ), p, found - p );

						p := found;
					end;
				end;

				// Attribute ̒lǂݍ
				p := AnsiStrNonTok( p, tail, kXMLWhite );

				while p < tail do
				begin
					if XMLCloseCheck( p, tail, node, tag, isClosed ) then
					begin
						if isClosed then
						begin
							if Length( attributeName ) > 0 then
								// KiOǂ
								node.AddAttribute( attributeName, attributeValue );

							// ^Oꂽ̂Ń^[
							// NodeName ʉ߂Ă̂œrŕĂ邱ƂɂȂB
							// ēƗm[hB
							exit;
						end;

						// ̃m[h
						goto NextNode;
					end else if p^ = '"' then
					begin
						// l "" ŊĂ̂(ĂĂȂႢȂ񂾂)
						// lꊇǂݍ
						Inc( p );
						found := AnsiStrTok( p, tail, kXMLDQuote );
//						attributeValue := Copy( p, 0, found - p );	// ̂x
						SetLength( attributeValue, found - p );
						CopyMemory( PChar( attributeValue ), p, found - p );

						node.AddAttribute( attributeName, HtmlDecode( attributeValue ) );

						// lǂݏÎŏI
						p := found + 1; // '"' ΂
						break;
					end else if p^ in kXMLWhite then
					begin
						// KiOǂ
						node.AddAttribute( attributeName, HtmlDecode( attributeValue ) );

						goto NextNode;
					end else begin
						// KiOǈꉞĂ
						attributeValue := attributeValue + p^;

						if p^ in kXMLKanji then
						begin
							attributeValue := attributeValue + (p + 1)^;
							p := p + 2;
						end else begin
							Inc( p );
						end;
					end;
				end;
			end; // Attribute ̓ǂݍ

			NextNode:;
		end; // // node ̓ǂݍ(1 [vɂ 1 m[h)
	finally
	end;
end;

procedure LoadXMLDocument(
	const fileName : string;
	var doc : IXMLDocument
);
type
	xmlMode = ( xmlHoge );
var
	xmlFile : TMappedFile;
	p				: PChar;
begin
		//Result := IXMLDocument.Create;
	//doc := IXMLDocument.Create;

	xmlFile := TMappedFile.Create( fileName );

	try
		p := xmlFile.Memory;
		XMLReadNode( p, p + xmlFile.Size, IXMLNode( doc ) );
		//XMLReadNode( xmlFile, IXMLNode( Result ) );
	finally
		xmlFile.Free;
	end;

	//Result := doc;

end;

end.
