unit ExternalBoardItem;

interface

uses
	Windows, Classes, SysUtils,
	IdComponent,
	ExternalBoardPlugInMain;

type
	// TBoardItem ̃vpeBݒ^擾 ID
	TBoardItemProperty = (
		bipContext,							// : DWORD				// Rɐݒ肵Ăl
		bipItems,								// : TThreadItem	// ɌqĂXbh
		bipNo,									// : Integer			// ԍ
		bipTitle,								// : string				// ^Cg
		bipRoundDate,						// : TDateTime		// 擾ij
		bipLastModified,				// : TDateTime		// XVĂiT[oj
		bipLastGetTime,					// : TDateTime		// Xbh܂̓XbhꗗŌɍXViT[oEݎɎgpj
		bipRound,								// : Boolean			// \
		bipRoundName,						// : string				// 
		bipIsLogFile,						// : Boolean			// O݃tO
		bipUnRead,							// : Integer			// Xbhǐ
		bipURL,									// : string				// uEUŕ\ۂ URL
		bipFilePath							// : string				// ̔ۑĂpX
	);

	// *************************************************************************
	// TBoardItem ꂽ
	// *************************************************************************
	TBoardItemCreate = procedure(
		inInstance : DWORD
	); stdcall;

	// *************************************************************************
	// TBoardItem jꂽ
	// *************************************************************************
	TBoardItemDispose = procedure(
		inInstance : DWORD
	); stdcall;

	// *************************************************************************
	// _E[hwꂽ
	// *************************************************************************
	TBoardItemOnDownload = function(
		inInstance	: DWORD					// CX^X
	) : TDownloadState; stdcall;	// _E[hǂ

	// *************************************************************************
	// XĂw
	// *************************************************************************
	TBoardItemOnCreateThread = function(
		inInstance	: DWORD;				// ThreadItem ̃CX^X
		inSubject		: PChar;				// X^C
		inName			: PChar;				// O(nh)
		inMail			: PChar;				// [AhX
		inMessage		: PChar					// {
	) : TDownloadState; stdcall;	// ݂ǂ

	// *************************************************************************
	// eX̏ԋp
	// *************************************************************************
	TBoardItemEnumThreadCallBack = function(
		inInstance	: DWORD;	// TBoardItem ̃CX^X
		inURL				: PChar;	// Xbh URL
		inTitle			: PChar;	// X^C
		inCount			: DWORD		// X̐
	) : Boolean; stdcall;		// 񋓂𑱂Ȃ True

	// *************************************************************************
	// ̔ɕۗLĂX
	// *************************************************************************
	TBoardItemOnEnumThread = procedure(
		inInstance	: DWORD;												// CX^X
		inCallBack	: TBoardItemEnumThreadCallBack	// ԋpׂR[obN
	); stdcall;

	// *************************************************************************
	// t@CXbh URL vꂽ
	// *************************************************************************
	TBoardItemOnFileName2ThreadURL = function(
		inInstance	: DWORD;												// CX^X
		inFileName	: PChar													// ɂȂt@C
	) : PChar; stdcall;

implementation

uses ExternalBoardManager, GikoSystem, BoardGroup;

// *************************************************************************
// TBoardItem NX̃vpeB擾
// *************************************************************************
function BoardItemGetLong(
	instance		: DWORD;
	propertyID	: TBoardItemProperty
) : DWORD; stdcall;
var
	boardItem : TBoard;
begin

	boardItem := TBoard( instance );
	case propertyID of
		bipContext:							// : DWORD				// Rɐݒ肵Ăl
			Result := boardItem.Context;
		bipNo:									// : Integer			// ԍ
			Result := boardItem.No;
		bipTitle:								// : string				// Xbh^Cg
			Result := DWORD( CreateResultString( boardItem.Title ) );
		bipRound:								// : Boolean			// tO
			Result := DWORD( boardItem.Round );
		bipRoundName:						// : string				// 
			Result := DWORD( CreateResultString( boardItem.RoundName ) );
		bipIsLogFile:						// : Boolean			// O݃tO
			Result := DWORD( boardItem.IsLogFile );
		bipUnRead:							// : Integer			// Xbhǐ
			Result := DWORD( boardItem.UnRead );
		bipURL:									// : string				// XbhuEUŕ\ۂ URL
			Result := DWORD( CreateResultString( boardItem.URL ) );
		bipFilePath:															// ̃XۑĂpX
			Result := DWORD( CreateResultString( boardItem.FilePath ) );
	else
		Result := 0;
	end;
end;

// *************************************************************************
// TBoardItem NX̃vpeBݒ肷
// *************************************************************************
procedure BoardItemSetLong(
	instance		: DWORD;
	propertyID	: TBoardItemProperty;
	param : DWORD
); stdcall;
var
	boardItem	: TBoard;
begin

	boardItem := TBoard( instance );
	case propertyID of
		bipContext:							// : DWORD			// Rɐݒ肵Ăl
			boardItem.Context			:= param;
		bipNo:									// : Integer		// ԍ
			boardItem.No						:= param;
		bipTitle:								// : string			// Xbh^Cg
			boardItem.Title				:= string( PChar( param ) );
		bipRound:								// : Boolean		// tO
			boardItem.Round				:= Boolean( param );
		bipRoundName:						// : string			// 
			boardItem.RoundName		:= string( PChar( param ) );
		bipIsLogFile:						// : Boolean		// O݃tO
			boardItem.IsLogFile		:= Boolean( param );
		bipUnRead:							// : Integer		// Xbhǐ
			boardItem.UnRead				:= Integer( param );
		bipURL:									// : string			// XbhuEUŕ\ۂ URL
			boardItem.URL					:= string( PChar( param ) );
		bipFilePath:						// : string			// ̃XۑĂpX
			boardItem.FilePath			:= string( PChar( param ) );
	end;

end;

// *************************************************************************
// TBoardItem NX̃vpeB擾
// *************************************************************************
function BoardItemGetDouble(
	instance		: DWORD;
	propertyID	: TBoardItemProperty
) : Double; stdcall;
var
	boardItem : TBoard;
begin

	boardItem := TBoard( instance );
	case propertyID of
		bipRoundDate:						// : TDateTime	// Xbh擾ij
			Result := boardItem.RoundDate;
		bipLastModified:				// : TDateTime	// XbhXVĂiT[oj
			Result := boardItem.LastModified;
		bipLastGetTime:					// : TDateTime	// Xbh܂̓XbhꗗŌɍXViT[oEݎɎgpj
			Result := boardItem.LastGetTime;
	else
		Result := 0;
	end;

end;

// *************************************************************************
// TBoardItem NX̃vpeBݒ肷
// *************************************************************************
procedure BoardItemSetDouble(
	instance		: DWORD;
	propertyID	: TBoardItemProperty;
	param				: Double
); stdcall;
var
	boardItem : TBoard;
begin

	boardItem := TBoard( instance );
	case propertyID of
		bipRoundDate:						// : TDateTime	// Xbh擾ij
			boardItem.RoundDate		:= param;
		bipLastModified:				// : TDateTime	// XbhXVĂiT[oj
			boardItem.LastModified	:= param;
		bipLastGetTime:					// : TDateTime	// Xbh܂̓XbhꗗŌɍXViT[oEݎɎgpj
			boardItem.LastGetTime	:= param;
	end;

end;

// *************************************************************************
// TBoardItem NXɌqĂ TThreadItem NX擾
// *************************************************************************
function BoardItemGetItems(
	instance	: DWORD;
	index			: Integer
) : DWORD; stdcall;
var
	boardItem : TBoard;
begin

	boardItem	:= TBoard( instance );
	Result		:= DWORD( boardItem.Items[ index ] );

end;

// *************************************************************************
// ̃_E[his
// *************************************************************************
procedure BoardItemWork(
	inInstance	: DWORD;			// NX̃CX^X
	inWorkCount	: Integer			// ݂̐i(JEg)
); stdcall;
begin

	if Assigned( OnWork ) then
		OnWork( TObject( inInstance ), wmRead, inWorkCount );

end;

// *************************************************************************
// ̃_E[hn܂
// *************************************************************************
procedure BoardItemWorkBegin(
	inInstance			: DWORD;	// NX̃CX^X
	inWorkCountMax	: Integer	// ʐM̏IJEg
); stdcall;
begin

	if Assigned( OnWorkBegin ) then
		OnWorkBegin( TObject( inInstance ), wmRead, inWorkCountMax );

end;

// *************************************************************************
// ̃_E[hI
// *************************************************************************
procedure BoardItemWorkEnd(
	inInstance	: DWORD				// NX̃CX^X
); stdcall;
begin

	if Assigned( OnWorkEnd ) then
		OnWorkEnd( TObject( inInstance ), wmRead );

end;

// *************************************************************************
// ۗLXꗗ̗񋓏vO{̂ɔCꂽ
// *************************************************************************
procedure BoardItemEnumThread(
	inInstance		: DWORD;
	inCallBack		: TBoardItemEnumThreadCallBack;
	inSubjectText	: PChar
); stdcall;
var
	board					: TBoard;
	subject				: TStringList;
	i							: Integer;
	rec						: TSubjectRec;
	isContinue		: Boolean;
begin

	{$IFDEF DEBUG}
	Writeln('ExternalBoardManager.BoardItemEnumThread');
	{$ENDIF}
	try
		board		:= TBoard( inInstance );
		subject	:= TStringList.Create;
		try
			subject.Text := inSubjectText;

			for i := 0 to subject.Count - 1 do begin
				rec						:= GikoSys.DivideSubject( subject[i] );
				rec.FFileName	:= Trim(rec.FFileName);
				if (rec.FTitle = '') and (rec.FCount = 0) then
					Continue;

				isContinue := inCallBack(
					inInstance,
					PChar( board.BoardPlugIn.FileName2ThreadURL( DWORD( board ), rec.FFileName ) ),
					PChar( rec.FTitle ),
					DWORD( rec.FCount ) );

				if ( not isContinue ) then
					Break;
			end;
		finally
			subject.Free;
		end;
	except
	end;

end;

exports
	BoardItemGetLong,
	BoardItemSetLong,
	BoardItemGetDouble,
	BoardItemSetDouble,
	BoardItemGetItems,
	BoardItemEnumThread,
	BoardItemWork,
	BoardItemWorkBegin,
	BoardItemWorkEnd;

end.
 