/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.hbm2x.Exporter;
import org.hibernate.tool.hbm2x.QueryExporter;

public class QueryExporterTask
extends ExporterTask {
    private String query = "";
    private String filename;
    List queries = new ArrayList();

    public QueryExporterTask(HibernateToolTask parent) {
        super(parent);
    }

    protected Exporter configureExporter(Exporter exp) {
        QueryExporter exporter = (QueryExporter)exp;
        ArrayList<String> queryStrings = new ArrayList<String>();
        if (StringHelper.isNotEmpty((String)this.query)) {
            queryStrings.add(this.query);
        }
        for (HQL hql : this.queries) {
            if (!StringHelper.isNotEmpty((String)hql.query)) continue;
            queryStrings.add(hql.query);
        }
        exporter.setQueries(queryStrings);
        exporter.setFilename(this.filename);
        super.configureExporter(exp);
        return exporter;
    }

    public void validateParameters() {
        super.validateParameters();
        if (StringHelper.isEmpty((String)this.query) && this.queries.isEmpty()) {
            throw new BuildException("Need to specify at least one query.");
        }
        for (HQL hql : this.queries) {
            if (!StringHelper.isEmpty((String)hql.query)) continue;
            throw new BuildException("Query must not be empty");
        }
    }

    protected Exporter createExporter() {
        QueryExporter exporter = new QueryExporter();
        return exporter;
    }

    public void addText(String text) {
        if (StringHelper.isNotEmpty((String)text)) {
            this.query = this.query + QueryExporterTask.trim(text);
        }
    }

    private static String trim(String text) {
        return text.trim();
    }

    public HQL createHql() {
        HQL hql = new HQL();
        this.queries.add(hql);
        return hql;
    }

    public void setDestFile(String filename) {
        this.filename = filename;
    }

    public void execute() {
        this.parent.log("Executing: [" + this.query + "]");
        super.execute();
    }

    public String getName() {
        return "query (Executes queries)";
    }

    public static class HQL {
        String query = "";

        public void addText(String text) {
            if (StringHelper.isNotEmpty((String)text)) {
                this.query = this.query + QueryExporterTask.trim(text);
            }
        }
    }
}

