package batch.status;

import java.sql.Timestamp;

import core.util.DateUtil;

/**
 * ジョブ管理
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class Job {
	/** identifier field */
	private volatile long jobSeq;

	/** persistent field */
	private String jobId;

	/** persistent field */
	private String userId;

	/** persistent field */
	private Timestamp torokuDtm;

	/** nullable persistent field */
	private String[] jobParam = {};

	/** nullable persistent field */
	private String[] execParam = {};

	/** nullable persistent field */
	private String gamenParam;

	/** persistent field */
	private String jobName;

	/** persistent field */
	private String ipAdd;

	/** nullable persistent field */
	private String hostId;

	/** persistent field */
	private int jobSts;

	/** nullable persistent field */
	private String msgTxt;

	/** nullable persistent field */
	private String remark;

	/**
	 * 備考取得
	 *
	 * @return 備考
	 */
	public String getRemark() {
		return this.remark;
	}

	/**
	 * 備考設定
	 *
	 * @param val 備考
	 */
	public void setRemark(final String val) {
		this.remark = val;
	}

	/**
	 * ジョブパラメタ取得
	 *
	 * @return ジョブパラメタ
	 */
	public String[] getJobParam() {
		return this.jobParam.clone();
	}

	/**
	 * ジョブパラメタ設定
	 *
	 * @param val ジョブパラメタ（スペース区切り毎に1パラメタ）
	 */
	public void setJobParam(final String... val) {
		this.jobParam = val != null ? val.clone() : new String[0];
	}

	/**
	 * バッチ実行時パラメタ取得
	 *
	 * @return 実行時パラメタ
	 */
	public String[] getExecParam() {
		return this.execParam.clone();
	}

	/**
	 * バッチ実行時パラメタ設定
	 *
	 * @param val 実行時パラメタ（スペース区切り毎に1パラメタ）
	 */
	public void setExecParam(final String... val) {
		this.execParam = val != null ? val.clone() : new String[0];
	}

	/**
	 * 画面パラメタ取得
	 *
	 * @return 画面パラメタ
	 */
	public String getGamenParam() {
		return this.gamenParam;
	}

	/**
	 * 画面パラメタ設定
	 *
	 * @param val 画面パラメタ
	 */
	public void setGamenParam(final String val) {
		this.gamenParam = val;
	}

	/**
	 * ホストID取得
	 *
	 * @return ホストID
	 */
	public String getHostId() {
		return this.hostId;
	}

	/**
	 * ホストID設定
	 *
	 * @param val ホストID
	 */
	public void setHostId(final String val) {
		this.hostId = val;
	}

	/**
	 * IPアドレス取得
	 *
	 * @return IPアドレス
	 */
	public String getIp() {
		return this.ipAdd;
	}

	/**
	 * IPアドレス設定
	 *
	 * @param val IPアドレス
	 */
	public void setIp(final String val) {
		this.ipAdd = val;
	}

	/**
	 * ジョブID取得
	 *
	 * @return ジョブID
	 */
	public String getJobId() {
		return this.jobId;
	}

	/**
	 * ジョブID設定
	 *
	 * @param val ジョブID
	 */
	public void setJobId(final String val) {
		this.jobId = val;
	}

	/**
	 * ジョブ名取得
	 *
	 * @return ジョブ名
	 */
	public String getJobName() {
		return this.jobName;
	}

	/**
	 * ジョブ名設定
	 *
	 * @param val ジョブ名
	 */
	public void setJobName(final String val) {
		this.jobName = val;
	}

	/**
	 * ジョブ連番取得
	 *
	 * @return ジョブ連番
	 */
	public long getJobSeq() {
		return this.jobSeq;
	}

	/**
	 * ジョブ連番設定
	 *
	 * @param val ジョブ連番
	 */
	public void setJobSeq(final long val) {
		this.jobSeq = val;
	}

	/**
	 * ジョブステータス取得
	 *
	 * @return ジョブステータス
	 */
	public int getJobSts() {
		return this.jobSts;
	}

	/**
	 * ジョブステータス設定
	 *
	 * @param val ジョブステータス
	 */
	public void setJobSts(final int val) {
		this.jobSts = val;
	}

	/**
	 * メッセージテキスト取得
	 *
	 * @return メッセージテキスト
	 */
	public String getMsgTxt() {
		return this.msgTxt;
	}

	/**
	 * メッセージテキスト設定
	 *
	 * @param val メッセージテキスト
	 */
	public void setMsgTxt(final String val) {
		this.msgTxt = val;
	}

	/**
	 * 登録日時取得
	 *
	 * @return 登録日時
	 */
	public Timestamp getDateTime() {
		return DateUtil.copyOf(this.torokuDtm);
	}

	/**
	 * 登録日時設定
	 *
	 * @param val 登録日時
	 */
	public void setDateTime(final Timestamp val) {
		this.torokuDtm = DateUtil.copyOf(val);
	}

	/**
	 * ユーザID取得
	 *
	 * @return ユーザID
	 */
	public String getUid() {
		return this.userId;
	}

	/**
	 * ユーザID設定
	 *
	 * @param val ユーザID
	 */
	public void setUid(final String val) {
		this.userId = val;
	}
}
