package online.context.token;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * トークン実装
 *
 * @author Tadashi Nakayama
 */
public class TokenImpl implements Token {

	/**
	 * 文字列のダイジェストを16進文字列で返却する。
	 *
	 * @param str 元文字列
	 * @return ダイジェスト
	 */
	@Override
	public String toHashString(final String str) {
		try {
			final MessageDigest md = MessageDigest.getInstance("SHA-256");
			// バイト配列からダイジェストを計算する
			md.update(str.getBytes(StandardCharsets.ISO_8859_1));
			return toStringDigest(md.digest());
		} catch (final NoSuchAlgorithmException ex) {
			throw new IllegalStateException(ex);
		}
	}

	/**
	 * バイト配列を文字列に変換する。
	 *
	 * @param digest バイト配列
	 * @return 変換後文字列
	 */
	private static String toStringDigest(final byte[] digest) {
		// 返却値
		final StringBuilder sb = new StringBuilder();
		for (final byte d : digest) {
			sb.append(String.format("%02x", Byte.valueOf(d)));
		}
		return sb.toString();
	}
}
