CREATE TABLE TR_GENERIC_UPLOAD
(
    ID                          BIGINT         PRIMARY KEY,
    NAME                        VARCHAR(256)  NOT NULL,
    FILE_NAME                   VARCHAR(256)  NOT NULL,
    UPLOAD_COUNT                INTEGER       NOT NULL,
    TOTAL_COUNT                 INTEGER       NOT NULL,
    INSERT_DATETIME             TIMESTAMP     NOT NULL,
    INSERT_ID                   VARCHAR(32)   NOT NULL,
    UPDATE_DATETIME             TIMESTAMP     NOT NULL,
    UPDATE_ID                   VARCHAR(32)   NOT NULL,
    VERSION                     INTEGER       NOT NULL DEFAULT 1
)
;

COMMENT ON TABLE TR_GENERIC_UPLOAD IS '汎用アップロード管理';
COMMENT ON COLUMN TR_GENERIC_UPLOAD.ID IS 'ID';
COMMENT ON COLUMN TR_GENERIC_UPLOAD.NAME IS '名称';
COMMENT ON COLUMN TR_GENERIC_UPLOAD.FILE_NAME IS 'ファイル名';
COMMENT ON COLUMN TR_GENERIC_UPLOAD.UPLOAD_COUNT IS '更新件数';
COMMENT ON COLUMN TR_GENERIC_UPLOAD.TOTAL_COUNT IS '総件数';
COMMENT ON COLUMN TR_GENERIC_UPLOAD.INSERT_DATETIME IS '作成日時';
COMMENT ON COLUMN TR_GENERIC_UPLOAD.INSERT_ID IS '作成者';
COMMENT ON COLUMN TR_GENERIC_UPLOAD.UPDATE_DATETIME IS '更新日時';
COMMENT ON COLUMN TR_GENERIC_UPLOAD.UPDATE_ID IS '更新者';
COMMENT ON COLUMN TR_GENERIC_UPLOAD.VERSION IS 'バージョン';
