--encoding:UTF-8
SELECT
  JDT.BAT_SEQ AS BAT_SEQ,
  JDT.BAT_NAME AS BAT_NAME,
  JDT.STATUS AS STATUS,
  JDT.START_DATE_TIME AS START_DATE_TIME,
  JDT.STOP_DATE_TIME AS STOP_DATE_TIME,
  JFT1.FILE_SEQ AS FILE_SEQ1,
  COALESCE(JFT1.DOWNLOAD_NAME, JFT1.FILE_NAME) AS FILE_NAME1,
  JFT1.FILE_SIZE AS FILE_SIZE1,
  JFT2.FILE_SEQ AS FILE_SEQ2,
  COALESCE(JFT2.DOWNLOAD_NAME, JFT2.FILE_NAME) AS FILE_NAME2,
  JFT2.FILE_SIZE AS FILE_SIZE2,
  JFT3.FILE_SEQ AS FILE_SEQ3,
  COALESCE(JFT3.DOWNLOAD_NAME, JFT3.FILE_NAME) AS FILE_NAME3,
  JFT3.FILE_SIZE AS FILE_SIZE3,
  JFT4.FILE_SEQ AS FILE_SEQ4,
  COALESCE(JFT4.DOWNLOAD_NAME, JFT4.FILE_NAME) AS FILE_NAME4,
  JFT4.FILE_SIZE AS FILE_SIZE4,
  JFT5.FILE_SEQ AS FILE_SEQ5,
  COALESCE(JFT5.DOWNLOAD_NAME, JFT5.FILE_NAME) AS FILE_NAME5,
  JFT5.FILE_SIZE AS FILE_SIZE5,
  COUNT(JDT.BAT_SEQ) OVER() AS CNT
FROM
  FW_JOB_DETAIL JDT
INNER JOIN
  FW_JOB_BASE JB
ON
  JB.JOB_SEQ = JDT.JOB_SEQ
LEFT OUTER JOIN
  FW_JOB_FILE JFT1
ON
  JFT1.JOB_SEQ = JDT.JOB_SEQ
  AND JFT1.BAT_SEQ = JDT.BAT_SEQ
  AND JFT1.FILE_SEQ = 1
LEFT OUTER JOIN
  FW_JOB_FILE JFT2
ON
  JFT2.JOB_SEQ = JDT.JOB_SEQ
  AND JFT2.BAT_SEQ = JDT.BAT_SEQ
  AND JFT2.FILE_SEQ = 2
LEFT OUTER JOIN
  FW_JOB_FILE JFT3
ON
  JFT3.JOB_SEQ = JDT.JOB_SEQ
  AND JFT3.BAT_SEQ = JDT.BAT_SEQ
  AND JFT3.FILE_SEQ = 3
LEFT OUTER JOIN
  FW_JOB_FILE JFT4
ON
  JFT4.JOB_SEQ = JDT.JOB_SEQ
  AND JFT4.BAT_SEQ = JDT.BAT_SEQ
  AND JFT4.FILE_SEQ = 4
LEFT OUTER JOIN
  FW_JOB_FILE JFT5
ON
  JFT5.JOB_SEQ = JDT.JOB_SEQ
  AND JFT5.BAT_SEQ = JDT.BAT_SEQ
  AND JFT5.FILE_SEQ = 5
WHERE
  JDT.JOB_SEQ = /*:JobSeq*/1
  AND JB.ENTRY_USER_ID = /*:UserIdSearch*/'nakayama'
ORDER BY
  JDT.JOB_SEQ, JDT.BAT_SEQ
