package project.check.attribute;

import java.util.Optional;
import java.util.stream.Stream;

import core.util.NumberUtil;
import core.util.bean.Pair;
import online.context.check.ItemCheck;
import online.context.check.ItemConvert;
import online.model.ModelUtil;
import project.check.BaseCheck;
import project.common.CheckUtil;

/**
 * 数値チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class NumeralCheck extends BaseCheck implements ItemCheck, ItemConvert<Integer> {

	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 */
	public NumeralCheck() {
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public NumeralCheck(final String msgId, final String... param) {
		this.mid = msgId;
		this.prm = super.copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			final String[] val = super.getArrayParameter(item);
			for (int j = 0; val != null && j < val.length; j++) {
				if (!super.isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(super.getUniModel(), item, j);
				} else if (!CheckUtil.isInteger(val[j])) {
					super.setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(j))));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}

	/**
	 * @see online.context.check.ItemConvert#convert(java.lang.String...)
	 */
	@Override
	public Integer[] convert(final String... val) {
		return Stream.of(val).map(NumberUtil::toInteger).toArray(Integer[]::new);
	}
}
