package project.check.master;

import java.util.Objects;
import java.util.Optional;

import core.config.Factory;
import core.util.bean.Pair;
import online.context.check.ItemCheck;
import online.model.ModelUtil;
import project.check.BaseCheck;
import project.svc.generic.QueryService;

/**
 * マスタ存在チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class MasterCheck extends BaseCheck implements ItemCheck {

	/** クエリファイル */
	private final String query;
	/** メッセージID */
	private final String mid;

	/**
	 * コンストラクタ
	 *
	 * @param sql クエリファイル
	 * @param msgId メッセージID
	 */
	public MasterCheck(final String msgId, final String sql) {
		this.query = sql;
		this.mid = msgId;
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		final QueryService ql = Factory.create(QueryService.class);
		ModelUtil.setModelValue(ql, super.getUniModel());
		ql.setSessionUser(super.getSessionUser());
		ql.setQueryFile(this.query);

		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			final String[] vals = super.getArrayParameter(item);
			for (int j = 0; vals != null && j < vals.length; j++) {
				if (!super.isTarget(j)) {
					vals[j] = ModelUtil.getValueAsString(super.getUniModel(), item, j);
				} else if (Objects.toString(vals[j], "").isEmpty()) {
					continue;
				} else if (!ql.search()) {
					super.setMessage(item, j, this.mid);
					check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(j))));
				}
			}
		}

		check.ifPresent(this::throwNoMoreCheckException);
	}
}
