package project.view.tag;

import javax.servlet.jsp.JspException;

import core.config.Factory;
import online.view.ViewUtil;
import online.view.tag.BaseTag;
import project.common.master.Msg;

/**
 * メッセージタグ
 * @author Tadashi Nakayama
 */
public final class MessageTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = -4276723836399909098L;

	/** 変数用変数 */
	private String var = null;
	/** 選択項目用変数 */
	private String msgId = null;
	/** 選択対象用変数 */
	private String[] param = null;
	/** メッセージのみフラグ */
	private boolean only = false;

	/**
	 * リリース処理
	 */
	@Override
	public void release() {
		this.var = null;
		this.msgId = null;
		this.param = null;
		this.only = false;
	}

	/**
	 * 変数設定
	 *
	 * @param val 保存変数名文字列
	 */
	public void setVar(final String val) {
		this.var = val;
	}

	/**
	 * メッセージID設定
	 * @param val メッセージID
	 */
	public void setMsgId(final String val) {
		this.msgId = val;
	}

	/**
	 * パラメタ設定
	 * @param val パラメタ
	 */
	public void setParameter(final String val) {
		this.param = ViewUtil.splitValue(val);
	}

	/**
	 * メッセージのみフラグ設定
	 * @param val メッセージのみフラグ
	 */
	public void setOnlyMsg(final String val) {
		this.only = Boolean.parseBoolean(val);
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() throws JspException {
		try {
			// アトリビュートクリア
			if (this.var != null) {
				this.pageContext.removeAttribute(this.var);
			}

			if (this.msgId != null) {
				super.output(this.var, getMessage());
			}
			return SKIP_BODY;
		} finally {
			release();
		}
	}

	/**
	 * メッセージ取得
	 * @return メッセージ
	 */
	private String getMessage() {
		final Msg msg = Factory.create(Msg.class);
		final String ret = msg.getMessage(this.msgId, this.param);
		// TODO メッセージのみ取得できるよう
		if (this.only) {
			return ret.replaceAll("\\[.*\\]", "");
		}
		return ret;
	}
}
