package batch.controller;

import common.db.JdbcSource;
import common.db.jdbc.Jdbc;

/**
 * ジョブユーティリティ
 *
 * @author Tadashi Nakayama
 */
public final class JobUtil {
	/**
	 * コンストラクタ
	 */
	private JobUtil() {
		throw new AssertionError();
	}

	/**
	 * 起動時間確認
	 *
	 * @param now 現在時刻
	 * @param start 可能開始時刻
	 * @param end 可能終了時刻
	 * @return 現在時刻が、可能開始時刻以降でかつ可能終了時刻より前なら true
	 */
	static boolean checkInTime(final String now, final String start, final String end) {
		if (start != null && end != null && start.compareTo(end) > 0) {
			return start.compareTo(now) <= 0 || end.compareTo(now) >= 0;
		}

		return (start == null || start.compareTo(now) <= 0)
				&& (end == null || end.compareTo(now) >= 0);
	}

	/**
	 * コネクション作成
	 *
	 * @return コネクション
	 */
	public static Jdbc getConnection() {
		if (JdbcSource.hasResource("Job")) {
			return JdbcSource.getConnection("Job");
		}
		return JdbcSource.getConnection();
	}
}
