package online.context.session;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * セション共通情報
 *
 * @author Tadashi Nakayama
 */
public class SessionUser implements Serializable {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** ユーザーIDキー */
	private static final String KEY_USER_ID = "SessionUserId";

	/** ユーザ属性 */
	private final Map<String, String> attribute = new HashMap<>();

	/**
	 * コンストラクタ
	 *
	 * @param uid ユーザID
	 */
	public SessionUser(final String uid) {
		this(uid, Collections.emptyMap());
	}

	/**
	 * コンストラクタ
	 *
	 * @param map ユーザ属性情報
	 */
	public SessionUser(final Map<String, String> map) {
		this(map.get(KEY_USER_ID), map);
	}

	/**
	 * コンストラクタ
	 *
	 * @param uid ユーザID
	 * @param map ユーザ属性情報
	 */
	public SessionUser(final String uid, final Map<String, String> map) {
		this.attribute.putAll(map);
		this.attribute.put(KEY_USER_ID, uid);
	}

	/**
	 * ユーザID取得
	 *
	 * @return ユーザID
	 */
	public String getUid() {
		return this.attribute.get(KEY_USER_ID);
	}

	/**
	 * ユーザ属性情報取得
	 *
	 * @param key キー
	 * @return ユーザ属性情報
	 */
	public String getAttribute(final String key) {
		return this.attribute.get(key);
	}

	/**
	 * ユーザ属性情報取得
	 *
	 * @return ユーザ属性情報
	 */
	public Map<String, String> getAttributeMap() {
		return new HashMap<>(this.attribute);
	}
}
