CREATE TABLE FW_JOB_FILE
(
  JOB_SEQ             NUMBER(10)      NOT NULL,
  BAT_SEQ             NUMBER(3)       NOT NULL,
  FILE_SEQ            NUMBER(3)       NOT NULL,
  FILE_NAME           VARCHAR2(128)   NOT NULL,
  FILE_PATH           VARCHAR2(256),
  FILE_SIZE           NUMBER(18),
  DOWNLOAD_NAME       VARCHAR2(128),
  DOWNLOAD_COUNT      NUMBER(4)       NOT NULL DEFAULT 0
)
;

ALTER TABLE FW_JOB_FILE ADD CONSTRAINT FW_JOB_FILE_PK PRIMARY KEY
(
  JOB_SEQ,
  BAT_SEQ,
  FILE_SEQ
)
;

COMMENT ON TABLE FW_JOB_FILE IS 'ファイル管理';
COMMENT ON COLUMN FW_JOB_FILE.JOB_SEQ IS 'ジョブ連番';
COMMENT ON COLUMN FW_JOB_FILE.BAT_SEQ IS 'バッチ連番';
COMMENT ON COLUMN FW_JOB_FILE.FILE_SEQ IS 'ファイル連番';
COMMENT ON COLUMN FW_JOB_FILE.FILE_NAME IS 'ファイル名';
COMMENT ON COLUMN FW_JOB_FILE.FILE_PATH IS 'ファイルパス';
COMMENT ON COLUMN FW_JOB_FILE.FILE_SIZE IS 'ファイルサイズ';
COMMENT ON COLUMN FW_JOB_FILE.DOWNLOAD_NAME IS 'ダウンロードファイル名';
COMMENT ON COLUMN FW_JOB_FILE.DOWNLOAD_COUNT IS 'ダウンロード回数';
