CREATE TABLE TR_GENERIC_CSV_CONDITION
(
    ID                          NUMBER(10)   NOT NULL,
    USER_PATTERN_NO             NUMBER(10)   NOT NULL,
    DTL_NO                      NUMBER(5)    NOT NULL,
    ITEM_NAME                   VARCHAR2(100),
    CONDITION_KBN               CHAR(2),
    CONDITION_ITEM              VARCHAR2(100),
    INSERT_DATETIME             TIMESTAMP    NOT NULL,
    INSERT_ID                   VARCHAR2(32) NOT NULL,
    UPDATE_DATETIME             TIMESTAMP    NOT NULL,
    UPDATE_ID                   VARCHAR2(32) NOT NULL,
    VERSION                     NUMBER(6)    NOT NULL DEFAULT 1,
    CONSTRAINT TR_GENERIC_CSV_CONDITION_PK PRIMARY KEY (ID),
    CONSTRAINT TR_GENERIC_CSV_UIX01 UNIQUE (USER_PATTERN_NO, DTL_NO)
)
;

COMMENT ON TABLE TR_GENERIC_CSV_CONDITION IS '汎用CSV条件登録';
COMMENT ON COLUMN TR_GENERIC_CSV_CONDITION.ID IS 'キー';
COMMENT ON COLUMN TR_GENERIC_CSV_CONDITION.USER_PATTERN_NO IS 'ユーザパターン番号';
COMMENT ON COLUMN TR_GENERIC_CSV_CONDITION.DTL_NO IS '詳細番号';
COMMENT ON COLUMN TR_GENERIC_CSV_CONDITION.CONDITION_ITEM_NAME IS '項目名';
COMMENT ON COLUMN TR_GENERIC_CSV_CONDITION.CONDITION_KBN IS '条件区分';
COMMENT ON COLUMN TR_GENERIC_CSV_CONDITION.CONDITION_ITEM IS '条件';
COMMENT ON COLUMN TR_GENERIC_CSV_CONDITION.INSERT_DATETIME IS '作成日時';
COMMENT ON COLUMN TR_GENERIC_CSV_CONDITION.INSERT_ID IS '作成ID';
COMMENT ON COLUMN TR_GENERIC_CSV_CONDITION.UPDATE_DATETIME IS '更新日時';
COMMENT ON COLUMN TR_GENERIC_CSV_CONDITION.UPDATE_ID IS '更新ID';
COMMENT ON COLUMN TR_GENERIC_CSV_CONDITION.VERSION IS 'バージョン';
