CREATE TABLE MS_GENERIC_UPLOAD
(
    ID                          BIGINT        PRIMARY KEY,
    NAME                        VARCHAR(256)  NOT NULL,
    CLASS                       VARCHAR(256)  NOT NULL,
    PARAM                       VARCHAR(1024),
    INSERT_DATETIME             TIMESTAMP     NOT NULL,
    INSERT_ID                   VARCHAR(32)   NOT NULL,
    UPDATE_DATETIME             TIMESTAMP     NOT NULL,
    UPDATE_ID                   VARCHAR(32)   NOT NULL,
    VERSION                     INTEGER       NOT NULL DEFAULT 1
)
;

COMMENT ON TABLE MS_GENERIC_UPLOAD IS '汎用アップロード';
COMMENT ON COLUMN MS_GENERIC_UPLOAD.ID IS 'ID';
COMMENT ON COLUMN MS_GENERIC_UPLOAD.NAME IS '名称';
COMMENT ON COLUMN MS_GENERIC_UPLOAD.CLASS IS 'クラス名';
COMMENT ON COLUMN MS_GENERIC_UPLOAD.PARAM IS 'クラスパラメタ';
COMMENT ON COLUMN MS_GENERIC_UPLOAD.INSERT_DATETIME IS '作成日時';
COMMENT ON COLUMN MS_GENERIC_UPLOAD.INSERT_ID IS '作成者';
COMMENT ON COLUMN MS_GENERIC_UPLOAD.UPDATE_DATETIME IS '更新日時';
COMMENT ON COLUMN MS_GENERIC_UPLOAD.UPDATE_ID IS '更新者';
COMMENT ON COLUMN MS_GENERIC_UPLOAD.VERSION IS 'バージョン';
