CREATE TABLE TR_GENERIC_CSV
(
    ID                          BIGINT       PRIMARY KEY,
    USER_PATTERN_NO             BIGINT       NOT NULL,
    USER_PATTERN_NAME           VARCHAR(100) NOT NULL,
    DEFINE_NAME                 VARCHAR(100) NOT NULL,
    HEADER                      CHAR(1)      NOT NULL,
    CONDITION_COLUMN            INTEGER,
    INSERT_DATETIME             TIMESTAMP    NOT NULL,
    INSERT_ID                   VARCHAR(32)  NOT NULL,
    UPDATE_DATETIME             TIMESTAMP    NOT NULL,
    UPDATE_ID                   VARCHAR(32)  NOT NULL,
    VERSION                     INTEGER      NOT NULL DEFAULT 1,
    CONSTRAINT TR_GENERIC_CSV_UIX01 UNIQUE (USER_PATTERN_NO)
)
;

COMMENT ON TABLE TR_GENERIC_CSV IS '汎用CSV登録';
COMMENT ON COLUMN TR_GENERIC_CSV.ID IS 'キー';
COMMENT ON COLUMN TR_GENERIC_CSV.USER_PATTERN_NO IS 'ユーザパターン番号';
COMMENT ON COLUMN TR_GENERIC_CSV.USER_PATTERN_NAME IS 'ユーザパターン名';
COMMENT ON COLUMN TR_GENERIC_CSV.DEFINE_NAME IS '使用定義名';
COMMENT ON COLUMN TR_GENERIC_CSV.HEADER IS 'ヘッダ出力フラグ';
COMMENT ON COLUMN TR_GENERIC_CSV.CONDITION_COLUMN IS '条件カラム数';
COMMENT ON COLUMN TR_GENERIC_CSV.INSERT_DATETIME IS '作成日時';
COMMENT ON COLUMN TR_GENERIC_CSV.INSERT_ID IS '作成ID';
COMMENT ON COLUMN TR_GENERIC_CSV.UPDATE_DATETIME IS '更新日時';
COMMENT ON COLUMN TR_GENERIC_CSV.UPDATE_ID IS '更新ID';
COMMENT ON COLUMN TR_GENERIC_CSV.VERSION IS 'バージョン';
