package common.db.dao.hibernate.platform;

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

import org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform;
import org.seasar.extension.jta.UserTransactionImpl;

import common.db.jdbc.provider.S2DataSourceProvider;

/**
 * S2Platform
 * @author Tadashi Nakayama
 */
public class S2JtaPlatform extends AbstractJtaPlatform {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/**
	 * @see org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform
	 * #locateTransactionManager()
	 */
	@Override
	protected TransactionManager locateTransactionManager() {
		return S2DataSourceProvider.getTransactionManager();
	}

	/**
	 * @see org.hibernate.engine.transaction.jta.platform.internal.AbstractJtaPlatform
	 * #locateUserTransaction()
	 */
	@Override
	protected UserTransaction locateUserTransaction() {
		return new UserTransactionImpl(S2DataSourceProvider.getTransactionManager());
	}
}
