package project.check.existence;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

import core.util.bean.Pair;
import online.context.check.ItemCheck;
import online.model.ModelUtil;
import project.check.BaseCheck;

/**
 * 選択項目配列内妥当性チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class ElementCheck extends BaseCheck implements ItemCheck {

	/** 項目チェック対象配列 */
	private final String[] array;
	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 * @param s 項目チェック対象配列
	 */
	public ElementCheck(final String[] s) {
		this.array = copyOf(s, new String[0]);
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param s 項目チェック対象配列
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public ElementCheck(final String[] s, final String msgId, final String... param) {
		this.array = copyOf(s, new String[0]);
		this.mid = msgId;
		this.prm = copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final var item : items) {
			final var val = getArrayParameter(item);
			for (var j = 0; val != null && j < val.length; j++) {
				if (!isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(getUniModel(), item, j);
				} else if (!Objects.toString(val[j], "").isEmpty()) {
					if (Stream.of(this.array).noneMatch(Predicate.isEqual(val[j]))) {
						setMessage(item, j, this.mid, this.prm);
						check = Optional.of(check.orElse(Pair.of(item, j)));
					}
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}
}
