package project.svc.generic;

import core.util.NumberUtil;
import project.base.UpdateAbstract;
import project.db.model.FwJobRepeat;

/**
 * 定期起動サービス
 * @author Tadashi Nakayama
 */
public final class RepeatService extends UpdateAbstract {

	/** バッチパラメタ */
	private String batParam;
	/** 表示パラメタ */
	private String dispParam;
	/** 実行時 */
	private String hour;
	/** 実行間隔 */
	private String interval;
	/** ジョブID */
	private String jobId;
	/** ジョブ名 */
	private String jobName;
	/** 実行分 */
	private String minute;
	/** 実行曜日 */
	private String week;
	/** 実行年月日 */
	private String yearMonthDay;

	/**
	 * @param val the batParam to set
	 */
	public void setBatParam(final String val) {
		this.batParam = val;
	}

	/**
	 * @param val the dispParam to set
	 */
	public void setDispParam(final String val) {
		this.dispParam = val;
	}

	/**
	 * @param val the hour to set
	 */
	public void setHour(final String val) {
		this.hour = val;
	}

	/**
	 * @param val the interval to set
	 */
	public void setInterval(final String val) {
		this.interval = val;
	}

	/**
	 * @param val the jobId to set
	 */
	public void setJobId(final String val) {
		this.jobId = val;
	}

	/**
	 * @param val the jobName to set
	 */
	public void setJobName(final String val) {
		this.jobName = val;
	}

	/**
	 * @param val the minute to set
	 */
	public void setMinute(final String val) {
		this.minute = val;
	}

	/**
	 * @param val the week to set
	 */
	public void setWeek(final String val) {
		this.week = val;
	}

	/**
	 * @param val the yearMonthDay to set
	 */
	public void setYearMonthDay(final String val) {
		this.yearMonthDay = val;
	}

	/**
	 * レコード作成
	 * @return ID
	 */
	public Long insert() {
		final var jr = new FwJobRepeat();
		jr.setBatParam(this.batParam);
		jr.setDispParam(this.dispParam);
		jr.setHour(this.hour);
		jr.setInterval(this.interval);
		jr.setJobId(this.jobId);
		jr.setJobName(this.jobName);
		jr.setMinute(this.minute);
		jr.setWeek(this.week);
		jr.setYearMonthDay(this.yearMonthDay);
		insert(jr);
		return jr.getId();
	}

	/**
	 * レコード削除
	 * @param id ID
	 * @param version バージョン
	 * @return 削除結果
	 */
	public boolean delete(final Number id, final Number version) {
		final var jr = findWithLock(FwJobRepeat.class, NumberUtil.toLong(id));
		return isUpdatable(jr, version) && delete(jr);
	}

	/**
	 * レコード更新
	 * @param id ID
	 * @param version バージョン
	 * @return 更新結果
	 */
	public boolean update(final Number id, final Number version) {
		final var jr = findWithLock(FwJobRepeat.class, id);
		if (isUpdatable(jr, version)) {
			jr.setBatParam(this.batParam);
			jr.setDispParam(this.dispParam);
			jr.setHour(this.hour);
			jr.setInterval(this.interval);
			jr.setJobId(this.jobId);
			jr.setJobName(this.jobName);
			jr.setMinute(this.minute);
			jr.setWeek(this.week);
			jr.setYearMonthDay(this.yearMonthDay);
			return update(jr);
		}
		return false;
	}
}
