package project.view.tag;

import java.util.ArrayList;
import java.util.List;

import core.config.Factory;
import online.view.ViewUtil;
import online.view.tag.BaseTag;
import project.master.CodeKeeper;
import project.master.CodeKeeper.Code;
import project.view.LabelValue;

/**
 * コードタグライブラリ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class CodeTag extends BaseTag {
	/** serialVersion */
	private static final long serialVersionUID = 1L;

	/** 変数用変数 */
	private String var = null;
	/** コード種別 */
	private String codesbt = null;
	/** コード */
	private String code = null;

	/**
	 * リリース処理
	 */
	@Override
	public void release() {
		this.var = null;
		this.codesbt = null;
		this.code = null;
	}

	/**
	 * 変数設定
	 *
	 * @param val 保存変数名文字列
	 */
	public void setVar(final String val) {
		this.var = val;
	}

	/**
	 * コード種別
	 * @param val コード種別
	 */
	public void setCodeSbt(final String val) {
		this.codesbt = val;
	}

	/**
	 * コード
	 * @param val コード
	 */
	public void setCode(final String val) {
		this.code = val;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() {
		try {
			doTag();
			return SKIP_BODY;
		} finally {
			release();
		}
	}

	/**
	 * タグ処理
	 */
	public void doTag() {
		if (this.var != null) {
			this.pageContext.removeAttribute(this.var);
		}

		final var ck = Factory.create(CodeKeeper.class);
		if (ck == null || this.codesbt == null) {
			return;
		}

		if (this.code != null) {
			final var t = ck.getCode(this.codesbt, this.code);
			if (t != null) {
				output(this.var, t.getName());
			}
		} else {
			final var list = ck.getCodeList(this.codesbt);
			if (list != null) {
				// 項目選択設定
				this.pageContext.setAttribute(this.var, toLabelValue(list));
			}
		}
	}

	/**
	 * リスト作成
	 * @param tl リスト
	 * @return リスト
	 */
	private List<LabelValue> toLabelValue(final List<Code> tl) {
		final var cs = ViewUtil.getCharset(getResponse());
		final var ret = new ArrayList<LabelValue>();
		for (final var t : tl) {
			final var lbl = ViewUtil.sanitize(t.getNameOption(), cs, true);
			final var val = ViewUtil.sanitize(t.getCode(), cs, true);
			final var cmt = ViewUtil.sanitize(t.getTxComment(), cs, true);
			ret.add(new LabelValue(lbl, val, cmt));
		}
		return ret;
	}
}
