package project.view.tag;

import java.util.ArrayList;
import java.util.List;

import core.config.Factory;
import online.view.ViewUtil;
import online.view.tag.BaseTag;
import project.common.master.AppConfig;
import project.view.LabelValue;

/**
 * APConfigタグ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class ConfigTag extends BaseTag {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** 変数用変数 */
	private String var = null;
	/** 機能ID */
	private String fid = null;
	/** 環境種別 */
	private String env = null;
	/** 詳細種別 */
	private String dtl = null;

	/**
	 * リリース処理
	 */
	@Override
	public void release() {
		this.var = null;
		this.fid = null;
		this.env = null;
		this.dtl = null;
	}

	/**
	 * 変数設定
	 *
	 * @param val 保存変数名文字列
	 */
	public void setVar(final String val) {
		this.var = val;
	}

	/**
	 * 機能ID設定
	 *
	 * @param val 機能ID
	 */
	public void setFid(final String val) {
		this.fid = val;
	}

	/**
	 * 環境種別設定
	 *
	 * @param val 環境種別
	 */
	public void setEnv(final String val) {
		this.env = val;
	}

	/**
	 * 詳細種別設定
	 *
	 * @param val 詳細種別
	 */
	public void setDtl(final String val) {
		this.dtl = val;
	}

	/**
	 * @see javax.servlet.jsp.tagext.TagSupport#doStartTag()
	 */
	@Override
	public int doStartTag() {
		try {
			doTag();
			return SKIP_BODY;
		} finally {
			release();
		}
	}

	/**
	 * タグ処理
	 */
	public void doTag() {
		// アトリビュートクリア
		if (this.var != null) {
			this.pageContext.removeAttribute(this.var);
		}

		final var ac = Factory.create(AppConfig.class);
		if (this.dtl != null) {
			final var val = ac.getValue(this.fid, this.env, this.dtl);
			output(this.var, ViewUtil.sanitize(val, ViewUtil.getCharset(getResponse()), true));
		} else if (this.var != null) {
			this.pageContext.setAttribute(this.var,
					createList(ac.getValueList(this.fid, this.env),
							ac.getDetailList(this.fid, this.env)));
		}
	}

	/**
	 * LabelValueリスト作成
	 * @param ll ラベルリスト
	 * @param vl バリューリスト
	 * @return LabelValueリスト
	 */
	private List<LabelValue> createList(final List<String> ll, final List<String> vl) {
		final var cs = ViewUtil.getCharset(getResponse());
		final var ret = new ArrayList<LabelValue>();
		for (var i = 0; i < ll.size(); i++) {
			final var lbl = ViewUtil.sanitize(ll.get(i), cs, true);
			final var val = ViewUtil.sanitize(vl.get(i), cs, true);
			ret.add(new LabelValue(lbl, val));
		}
		return ret;
	}
}
