package project.web.plugin;

import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

import common.master.IntervalTimer;
import core.config.Factory;
import project.common.master.Msg;
import project.master.CodeKeeper;

/**
 * プラグインクラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class InitialPlugIn implements PlugIn {

	/**
	 * 初期処理
	 *
	 * @param servlet サーブレット
	 * @param config 設定
	 */
	@Override
	public void init(final ActionServlet servlet, final ModuleConfig config) {
		//		final AppConfig ac = Factory.instantiate(AppConfig.class);
		//		ac.initialize();
		//		IntervalTimer.start(ac, 24d);

		final var msg = Factory.create(Msg.class);
		msg.initialize();
		IntervalTimer.start(msg, 5);

		final var ck = Factory.create(CodeKeeper.class);
		ck.initialize();
		IntervalTimer.start(ck, 24d);
	}

	/**
	 * 最終処理
	 *
	 */
	@Override
	public void destroy() {
		IntervalTimer.stop();
	}
}
