package project.web.processor;

import org.apache.commons.chain2.Processing;
import org.apache.struts.chain.contexts.ServletActionContext;

import online.struts.action.UniForm;
import online.struts.chain.command.RequestCommand;
import online.struts.mapping.RequestMapping;

/**
 * パターンリスト設定
 * @author Tadashi Nakayama
 */
public final class PatternListProcessor implements RequestCommand {

	/**
	 * @see online.struts.chain.command.RequestCommand
	 * #command(org.apache.struts.chain.contexts.ServletActionContext,
	 * online.struts.mapping.RequestMapping, online.struts.action.UniForm)
	 */
	@Override
	public Processing command(final ServletActionContext sac,
			final RequestMapping mapping, final UniForm uf) {
		if (!RequestCommand.isException(sac) && !sac.getResponse().isCommitted()
				&& sac.getForwardConfig() != null) {
			// 一覧設定
			PatternSearchProcessor.setPatternList(sac, uf);
		}
		return Processing.CONTINUE;
	}
}

