<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8" />
<title>汎用CSV一括登録</title>
<link rel="stylesheet" href="view/css/import.css" />
</head>

<body>
<header>
	<nav></nav>
	<section></section>
</header>
<main>
	<header>
		<h3>一括登録</h3>
		<div id="topMessage">${MESSAGE}</div>
	</header>
	<section>
		<div>
			<form id="batch" method="post" action="${ACTION_PATH}">
				<input type="hidden" name="Id" id="id" />
			</form>
			<table class="fixborder">
			<thead>
				<tr>
					<th>登録名称</th>
					<th colspan="2"></th>
				</tr>
			</thead>
			<c:forEach items="${band.IdBatchPattern}" var="bind">
			<tbody>
				<tr>
					<td>
						<a href="${ACTION_PATH}?Id=${bind.IdBatchPattern}" >${bind.NmBatchPattern}</a>
					</td>
					<td>
						<button type="button" class="delete" name="${bind.IdBatchPattern}">削除</button>
					</td>
					<td>
						<button type="button" class="output" name="${bind.IdBatchPattern}">出力</button>
					</td>
				</tr>
			</tbody>
			</c:forEach>
			</table>
		</div>

		<div>
			<a class="outputMake" href="javascript:void(0);">一括出力作成</a>

			<div id="outputMakeTbl" style="display:none">
				<form id="form" method="post">
				<div>
					<input type="hidden" name="Version" value="${empty Version ? '1' : Version}" />
					<input type="hidden" name="RepeatId" value="${RepeatId}" />
					<table class="fixborder dnd">
					<thead>
						<tr class="nodrag nodrop">
							<th>選択</th>
							<th>パターン名</th>
						</tr>
					</thead>
					<c:forEach items="${band.MyPatternValue}" var="bind">
					<tbody>
						<tr>
							<td class="center">
							<utl:checked var="chk" name="SelectId" value="${bind.MyPatternValue}" />
							<input type="checkbox" class="nodrag" name="SelectId" value="${chk}" />
							</td>
							<td>
							${bind.MyPatternLabel}
							</td>
						</tr>
					</tbody>
					</c:forEach>
					</table>
				</div>

				<div>
					<select name="Interval" class="interval">
						<option value=""></option>
						<utl:selected var="sel" name="Interval" value="next" />
						<option value="${sel}">次回</option>
						<utl:selected var="sel" name="Interval" value="day" />
						<option value="${sel}">毎日</option>
						<utl:selected var="sel" name="Interval" value="week" />
						<option value="${sel}">毎週</option>
						<utl:selected var="sel" name="Interval" value="month" />
						<option value="${sel}">毎月</option>
						<utl:selected var="sel" name="Interval" value="year" />
						<option value="${sel}">毎年</option>
					</select>
					<span class="hm" style="${empty Interval ? 'display:none;' : ''}">
					<select name="Hour">
						<c:forEach begin="0" end="23" varStatus="sts">
						<c:set var="num" value="${view:numfmt(sts.index, '00')}" />
						<utl:selected var="sel" name="Hour" value="${num}" />
						<option value="${sel}">${num}</option>
						</c:forEach>
					</select>
					<label>時</label>
					<select name="Minute">
						<c:forEach begin="0" end="5" varStatus="sts">
						<c:set var="num" value="${view:numfmt(sts.index * 10, '00')}" />
						<utl:selected var="sel" name="Minute" value="${num}" />
						<option value="${sel}">${num}</option>
						</c:forEach>
					</select>
					<label>分</label>
					</span>
					<span class="week" style="${Interval eq 'week' ? '' : 'display:none;'}">
					<select name="Week">
						<option value=""></option>
						<utl:selected var="sel" name="Week" value="2" />
						<option value="${sel}">月</option>
						<utl:selected var="sel" name="Week" value="3" />
						<option value="${sel}">火</option>
						<utl:selected var="sel" name="Week" value="4" />
						<option value="${sel}">水</option>
						<utl:selected var="sel" name="Week" value="5" />
						<option value="${sel}">木</option>
						<utl:selected var="sel" name="Week" value="6" />
						<option value="${sel}">金</option>
						<utl:selected var="sel" name="Week" value="7" />
						<option value="${sel}">土</option>
						<utl:selected var="sel" name="Week" value="1" />
						<option value="${sel}">日</option>
					</select>
					<label>曜日</label>
					</span>
					<span class="ymd" style="${not empty Interval and Interval ne 'week' and Interval ne 'day' ? '' : 'display:none;'}">
					<input type="text" name="YearMonthDay" value="${YearMonthDay}" class="year_month_day" maxlength="8" size="10" />
					<label class="ymd_label">${Interval eq 'next' ? '年月日' : (Interval eq 'year' ? '月日' : '日')}</label>
					</span>
				</div>

				<div>
					<label id="batchNameLabel">登録名称</label>
					<input type="text" name="BatchName" id="batchName" value="${BatchName}" maxlength="128" size="64"  />
				</div>
				</form>
			</div>

			<!-- 操作エリア -->
			<div>
				<button type="button" class="register">登録</button>
			</div>
		</div>
	</section>
	<aside>
	</aside>
	<footer>
	</footer>
</main>
<footer>
	<nav>
	</nav>
	<section>
	</section>
</footer>

<script src="view/js/jquery.min.js"></script>
<script src="view/js/jquery.tablednd.js"></script>
<script src="view/js/submit.js"></script>
<script src="view/js/csv/batch.js"></script>
</body>
</html>
