package core.util;

import java.math.BigDecimal;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * TestNumberUtil
 *
 */
public class TestNumberUtil {

	/**
	 * 数値オブジェクトBigDecimal変換
	 */
	@Test
	@DisplayName("数値オブジェクトBigDecimal変換")
	public void toNumberTest1() {
		Assertions.assertEquals(
				new BigDecimal("123"), NumberUtil.toNumber("123", BigDecimal.class));
	}

	/**
	 * 数値オブジェクトInteger変換
	 */
	@Test
	@DisplayName("数値オブジェクトInteger変換")
	public void toNumberTest2() {
		Assertions.assertEquals(
				Integer.valueOf("1234"), NumberUtil.toNumber("1,234", Integer.class));
	}

	/**
	 * 数値オブジェクトInteger変換不可
	 */
	@Test
	@DisplayName("数値オブジェクトInteger変換不可")
	public void toNumberTest3() {
		Assertions.assertNull(NumberUtil.toNumber("123AB", Integer.class));
	}

	/**
	 * 数値オブジェクト掛算nullONE
	 */
	@Test
	@DisplayName("数値オブジェクト掛算nullONE")
	public void multiplyTest1() {
		Assertions.assertEquals(BigDecimal.ONE, NumberUtil.multiply(null, BigDecimal.ONE));
	}

	/**
	 * 数値オブジェクト掛算ONEnull
	 */
	@Test
	@DisplayName("数値オブジェクト掛算ONEnull")
	public void multiplyTest2() {
		Assertions.assertEquals(BigDecimal.ONE, NumberUtil.multiply(BigDecimal.ONE, null));
	}

	/**
	 * 数値オブジェクト掛算nullnull
	 */
	@Test
	@DisplayName("数値オブジェクト掛算nullnull")
	public void multiplyTest3() {
		Assertions.assertNull(NumberUtil.multiply(null, null));
	}

	/**
	 * 数値オブジェクト掛算nullnullZERO
	 */
	@Test
	@DisplayName("数値オブジェクト掛算nullnullZERO")
	public void multiplyTest4() {
		Assertions.assertEquals(BigDecimal.ZERO, NumberUtil.multiply(null, null, BigDecimal.ZERO));
	}

	/**
	 * 数値オブジェクト掛算onenullTEN
	 */
	@Test
	@DisplayName("数値オブジェクト掛算onenullTEN")
	public void multiplyTest5() {
		Assertions.assertEquals(BigDecimal.TEN,
				NumberUtil.multiply(BigDecimal.ONE, null, BigDecimal.TEN));
	}

	/**
	 * Integer加算
	 */
	@Test
	@DisplayName("数値オブジェクト加算Integer")
	public void addIntegerTest1() {
		Assertions.assertEquals(Integer.valueOf(6), NumberUtil.add(1, 2, 3));
	}

	/**
	 * Long加算
	 */
	@Test
	@DisplayName("数値オブジェクト加算Long")
	public void addLongTest1() {
		Assertions.assertEquals(Long.valueOf(4), NumberUtil.add(1L, 2L, 1L));
	}

	/**
	 * BigDecimal加算
	 */
	@Test
	@DisplayName("数値オブジェクト加算BigDecimal")
	public void addLongBigDecimal1() {
		Assertions.assertEquals(new BigDecimal(11),
				NumberUtil.add(BigDecimal.ONE, BigDecimal.TEN));
	}

	/**
	 * int整数正常
	 */
	@Test
	@DisplayName("int整数正常")
	public void toIntTest1() {
		final Integer val = 1;
		Assertions.assertEquals(val, Integer.valueOf(NumberUtil.toInt(val.toString(), 0)));
	}

	/**
	 * int小数正常
	 */
	@Test
	@DisplayName("int小数正常")
	public void toIntTest2() {
		final String val = "1.24";
		Assertions.assertEquals(1, NumberUtil.toInt(val, 0));
	}
}
