package core.util.bean;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * CamelCaseTest
 */
public class CamelCaseTest {

	/**
	 * 先頭小文字
	 */
	@Test
	@DisplayName("先頭小文字")
	public void testToCamelCase1() {
		final var target = new CamelCase();
		Assertions.assertEquals("abCdEf", target.toCamelCase("AB_CD_ef"));
	}

	/**
	 * 先頭大毛寺
	 */
	@Test
	@DisplayName("先頭大文字")
	public void testToCamelCase2() {
		final var target = new CamelCase(true);
		Assertions.assertEquals("AbCdEf", target.toCamelCase("AB_CD_eF"));
	}
}
