package online.model;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * TestModelUtilBoolean
 *
 */
public class TestModelUtilBoolean {

	/**
	 * Bean->UniModel設定 Boolean 空
	 */
	@Test
	@DisplayName("Bean->UniModel設定 Boolean 空")
	public void setBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBooleanArray");
		ModelUtil.setBeanItemValue(um, bean, "Boolean");
		ModelUtil.setBeanItemValue(um, bean, "BooleanArray");

		Assertions.assertTrue(um.containsKey("PrimitiveBoolean"));
		Assertions.assertTrue(um.hasValue("PrimitiveBoolean"));
		Assertions.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBoolean"));
		Assertions.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assertions.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assertions.assertFalse(um.isArrayValue("PrimitiveBoolean"));

		Assertions.assertTrue(um.containsKey("PrimitiveBooleanArray"));
		Assertions.assertFalse(um.hasValue("PrimitiveBooleanArray"));
		Assertions.assertNull(um.getBoolean("PrimitiveBooleanArray"));
		Assertions.assertEquals(0, um.getArraySize("PrimitiveBooleanArray"));
		Assertions.assertEquals(0, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assertions.assertTrue(um.isArrayValue("PrimitiveBooleanArray"));

		Assertions.assertTrue(um.containsKey("Boolean"));
		Assertions.assertFalse(um.hasValue("Boolean"));
		Assertions.assertNull(um.getBoolean("Boolean"));
		Assertions.assertEquals(0, um.getArraySize("Boolean"));
		Assertions.assertEquals(0, um.getBooleanArray("Boolean").length);
		Assertions.assertFalse(um.isArrayValue("Boolean"));

		Assertions.assertTrue(um.containsKey("BooleanArray"));
		Assertions.assertFalse(um.hasValue("BooleanArray"));
		Assertions.assertNull(um.getBoolean("BooleanArray"));
		Assertions.assertEquals(0, um.getArraySize("BooleanArray"));
		Assertions.assertEquals(0, um.getBooleanArray("BooleanArray").length);
		Assertions.assertTrue(um.isArrayValue("BooleanArray"));
	}

	/**
	 * Bean->UniModel設定 boolean 配列
	 */
	@Test
	@DisplayName("Bean->UniModel設定 boolean 配列")
	public void setBeanItemValueTest2() {
		final JavaBean bean = new JavaBean();
		bean.setPrimitiveBoolean(true);
		bean.setPrimitiveBooleanArray(new boolean[]{false, true});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveBooleanArray");

		Assertions.assertTrue(um.containsKey("PrimitiveBoolean"));
		Assertions.assertTrue(um.hasValue("PrimitiveBoolean"));
		Assertions.assertEquals(Boolean.TRUE, um.getBoolean("PrimitiveBoolean"));
		Assertions.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assertions.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assertions.assertFalse(um.isArrayValue("PrimitiveBoolean"));

		Assertions.assertTrue(um.containsKey("PrimitiveBooleanArray"));
		Assertions.assertTrue(um.hasValue("PrimitiveBooleanArray"));
		Assertions.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBooleanArray"));
		Assertions.assertEquals(2, um.getArraySize("PrimitiveBooleanArray"));
		Assertions.assertEquals(2, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assertions.assertTrue(um.isArrayValue("PrimitiveBooleanArray"));
	}

	/**
	 * Bean->UniModel設定 Boolean 配列
	 */
	@Test
	@DisplayName("Bean->UniModel設定 Boolean 配列")
	public void setBeanItemValueTest3() {
		final JavaBean bean = new JavaBean();
		bean.setBoolean(Boolean.TRUE);
		bean.setBooleanArray(new Boolean[]{Boolean.FALSE, Boolean.TRUE});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "Boolean");
		ModelUtil.setBeanItemValue(um, bean, "BooleanArray");

		Assertions.assertTrue(um.containsKey("Boolean"));
		Assertions.assertTrue(um.hasValue("Boolean"));
		Assertions.assertEquals(Boolean.TRUE, um.getBoolean("Boolean"));
		Assertions.assertEquals(1, um.getArraySize("Boolean"));
		Assertions.assertEquals(1, um.getBooleanArray("Boolean").length);
		Assertions.assertFalse(um.isArrayValue("Boolean"));

		Assertions.assertTrue(um.containsKey("BooleanArray"));
		Assertions.assertTrue(um.hasValue("BooleanArray"));
		Assertions.assertEquals(Boolean.FALSE, um.getBoolean("BooleanArray"));
		Assertions.assertEquals(2, um.getArraySize("BooleanArray"));
		Assertions.assertEquals(2, um.getBooleanArray("BooleanArray").length);
		Assertions.assertTrue(um.isArrayValue("BooleanArray"));
	}


	/**
	 * Bean->UniModel追加 Boolean boolean 空
	 */
	@Test
	@DisplayName("Bean->UniModel追加 Boolean boolean 空")
	public void addBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBooleanArray");
		ModelUtil.addBeanItemValue(um, bean, "Boolean");
		ModelUtil.addBeanItemValue(um, bean, "BooleanArray");

		Assertions.assertTrue(um.containsKey("PrimitiveBoolean"));
		Assertions.assertTrue(um.hasValue("PrimitiveBoolean"));
		Assertions.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBoolean"));
		Assertions.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assertions.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assertions.assertFalse(um.isArrayValue("PrimitiveBoolean"));

		Assertions.assertTrue(um.containsKey("PrimitiveBooleanArray"));
		Assertions.assertTrue(um.hasValue("PrimitiveBooleanArray"));
		Assertions.assertNull(um.getBoolean("PrimitiveBooleanArray"));
		Assertions.assertEquals(1, um.getArraySize("PrimitiveBooleanArray"));
		Assertions.assertEquals(1, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assertions.assertTrue(um.isArrayValue("PrimitiveBooleanArray"));

		Assertions.assertTrue(um.containsKey("Boolean"));
		Assertions.assertTrue(um.hasValue("Boolean"));
		Assertions.assertNull(um.getBoolean("Boolean"));
		Assertions.assertEquals(1, um.getArraySize("Boolean"));
		Assertions.assertEquals(1, um.getBooleanArray("Boolean").length);
		Assertions.assertFalse(um.isArrayValue("Boolean"));

		Assertions.assertTrue(um.containsKey("BooleanArray"));
		Assertions.assertTrue(um.hasValue("BooleanArray"));
		Assertions.assertNull(um.getBoolean("BooleanArray"));
		Assertions.assertEquals(1, um.getArraySize("BooleanArray"));
		Assertions.assertEquals(1, um.getBooleanArray("BooleanArray").length);
		Assertions.assertTrue(um.isArrayValue("BooleanArray"));
	}

	/**
	 * Bean->UniModel追加 boolean 配列
	 */
	@Test
	@DisplayName("Bean->UniModel追加 boolean 配列")
	public void addBeanItemValueTest2() {
		final JavaBean bean = new JavaBean();
		bean.setPrimitiveBoolean(true);
		bean.setPrimitiveBooleanArray(new boolean[]{false, true});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBoolean");
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveBooleanArray");

		Assertions.assertTrue(um.containsKey("PrimitiveBoolean"));
		Assertions.assertTrue(um.hasValue("PrimitiveBoolean"));
		Assertions.assertEquals(Boolean.TRUE, um.getBoolean("PrimitiveBoolean"));
		Assertions.assertEquals(1, um.getArraySize("PrimitiveBoolean"));
		Assertions.assertEquals(1, um.getBooleanArray("PrimitiveBoolean").length);
		Assertions.assertFalse(um.isArrayValue("PrimitiveBoolean"));

		Assertions.assertTrue(um.containsKey("PrimitiveBooleanArray"));
		Assertions.assertTrue(um.hasValue("PrimitiveBooleanArray"));
		Assertions.assertEquals(Boolean.FALSE, um.getBoolean("PrimitiveBooleanArray"));
		Assertions.assertEquals(2, um.getArraySize("PrimitiveBooleanArray"));
		Assertions.assertEquals(2, um.getBooleanArray("PrimitiveBooleanArray").length);
		Assertions.assertTrue(um.isArrayValue("PrimitiveBooleanArray"));
	}

	/**
	 * Bean->UniModel追加 Boolean 配列
	 */
	@Test
	@DisplayName("Bean->UniModel追加 Boolean 配列")
	public void addBeanItemValueTest3() {
		final JavaBean bean = new JavaBean();
		bean.setBoolean(Boolean.TRUE);
		bean.setBooleanArray(new Boolean[]{Boolean.FALSE, Boolean.TRUE});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "Boolean");
		ModelUtil.addBeanItemValue(um, bean, "BooleanArray");

		Assertions.assertTrue(um.containsKey("Boolean"));
		Assertions.assertTrue(um.hasValue("Boolean"));
		Assertions.assertEquals(Boolean.TRUE, um.getBoolean("Boolean"));
		Assertions.assertEquals(1, um.getArraySize("Boolean"));
		Assertions.assertEquals(1, um.getBooleanArray("Boolean").length);
		Assertions.assertFalse(um.isArrayValue("Boolean"));

		Assertions.assertTrue(um.containsKey("BooleanArray"));
		Assertions.assertTrue(um.hasValue("BooleanArray"));
		Assertions.assertEquals(Boolean.FALSE, um.getBoolean("BooleanArray"));
		Assertions.assertEquals(2, um.getArraySize("BooleanArray"));
		Assertions.assertEquals(2, um.getBooleanArray("BooleanArray").length);
		Assertions.assertTrue(um.isArrayValue("BooleanArray"));
	}


	/**
	 * UniModel→Bean設定 空
	 */
	@Test
	@DisplayName("UniModel→Bean設定 空")
	public void setModelValueTest1() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um);

		Assertions.assertFalse(bean.isPrimitiveBoolean());
		Assertions.assertNull(bean.isPrimitiveBooleanArray());
		Assertions.assertNull(bean.isBoolean());
		Assertions.assertNull(bean.isBooleanArray());
	}

	/**
	 * UniModel→Bean設定 Boolean 配列
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Boolean 配列")
	public void setModelValueTest2() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", Boolean.TRUE);
		um.setValue("PrimitiveBooleanArray", Boolean.FALSE, Boolean.TRUE);
		um.setValue("Boolean", Boolean.TRUE);
		um.setValue("BooleanArray", Boolean.FALSE, Boolean.TRUE);
		ModelUtil.setModelValue(bean, um);

		Assertions.assertTrue(bean.isPrimitiveBoolean());
		Assertions.assertFalse(bean.isPrimitiveBooleanArray()[0]);
		Assertions.assertTrue(bean.isPrimitiveBooleanArray()[1]);
		Assertions.assertEquals(Boolean.TRUE, bean.isBoolean());
		Assertions.assertEquals(Boolean.FALSE, bean.isBooleanArray()[0]);
		Assertions.assertEquals(Boolean.TRUE, bean.isBooleanArray()[1]);
	}

	/**
	 * UniModel→Bean設定 BooleanからString
	 */
	@Test
	@DisplayName("UniModel→Bean設定 BooleanからString")
	public void setModelValueTest3() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", Boolean.FALSE, Boolean.TRUE);
		um.setValue("StringArray", Boolean.FALSE, Boolean.TRUE);
		ModelUtil.setModelValue(bean, um);

		Assertions.assertEquals("false", bean.getString());
		Assertions.assertEquals("false", bean.getStringArray()[0]);
		Assertions.assertEquals("true", bean.getStringArray()[1]);
	}


	/**
	 * UniModel→Bean 空
	 */
	@Test
	@DisplayName("UniModel→Bean 空")
	public void setModelValueTest10() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertFalse(bean.isPrimitiveBoolean());
		Assertions.assertNull(bean.isPrimitiveBooleanArray());
		Assertions.assertNull(bean.isBoolean());
		Assertions.assertNull(bean.isBooleanArray());
	}

	/**
	 * UniModel→Bean Boolean配列
	 */
	@Test
	@DisplayName("UniModel→Bean Boolean配列")
	public void setModelValueTest11() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", Boolean.FALSE, Boolean.TRUE);
		um.setValue("Boolean", Boolean.FALSE, Boolean.TRUE);
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertTrue(bean.isPrimitiveBoolean());
		Assertions.assertEquals(Boolean.TRUE, bean.isBoolean());
		Assertions.assertNull(bean.isPrimitiveBooleanArray());
		Assertions.assertNull(bean.isBooleanArray());
	}

	/**
	 * UniModel→Bean BooleanからString
	 */
	@Test
	@DisplayName("UniModel→Bean BooleanからString")
	public void setModelValueTest12() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", Boolean.FALSE, Boolean.TRUE);
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertEquals("true", bean.getString());
		Assertions.assertNull(bean.getStringArray());
	}

	/**
	 * UniModel→Bean BooleanからString
	 */
	@Test
	@DisplayName("UniModel→Bean BooleanからString")
	public void setModelValueTest31() {
		final JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray("String");

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", Boolean.FALSE, Boolean.TRUE);
		um.setValue("StringArray", Boolean.TRUE, Boolean.FALSE);

		ModelUtil.setModelValue(bean, um, 2);

		Assertions.assertEquals("String", bean.getString());
		Assertions.assertNotNull(bean.getStringArray());
		Assertions.assertEquals(2, bean.getStringArray().length);
		Assertions.assertEquals("true", bean.getStringArray()[0]);
		Assertions.assertEquals("false", bean.getStringArray()[1]);
	}
}
