package online.model;

import java.util.Date;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * TestModelUtilDate
 *
 */
public class TestModelUtilDate {

	/**
	 * Bean->UniModel設定 Date 空
	 */
	@Test
	@DisplayName("Bean->UniModel設定 Date 空")
	public void setBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "Date");
		ModelUtil.setBeanItemValue(um, bean, "DateArray");

		Assertions.assertTrue(um.containsKey("Date"));
		Assertions.assertFalse(um.hasValue("Date"));
		Assertions.assertNull(um.getDate("Date"));
		Assertions.assertEquals(0, um.getArraySize("Date"));
		Assertions.assertEquals(0, um.getDateArray("Date").length);
		Assertions.assertFalse(um.isArrayValue("Date"));

		Assertions.assertTrue(um.containsKey("DateArray"));
		Assertions.assertFalse(um.hasValue("DateArray"));
		Assertions.assertNull(um.getDate("DateArray"));
		Assertions.assertEquals(0, um.getArraySize("DateArray"));
		Assertions.assertEquals(0, um.getDateArray("DateArray").length);
		Assertions.assertTrue(um.isArrayValue("DateArray"));
	}

	/**
	 * Bean->UniModel設定 Date 配列
	 */
	@Test
	@DisplayName("Bean->UniModel設定 Date 配列")
	public void setBeanItemValueTest2() {
		final Date now = new Date();
		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "Date");
		ModelUtil.setBeanItemValue(um, bean, "DateArray");

		Assertions.assertTrue(um.containsKey("Date"));
		Assertions.assertTrue(um.hasValue("Date"));
		Assertions.assertEquals(now, um.getDate("Date"));
		Assertions.assertEquals(1, um.getArraySize("Date"));
		Assertions.assertEquals(1, um.getDateArray("Date").length);
		Assertions.assertFalse(um.isArrayValue("Date"));

		Assertions.assertTrue(um.containsKey("DateArray"));
		Assertions.assertTrue(um.hasValue("DateArray"));
		Assertions.assertEquals(now, um.getDate("DateArray"));
		Assertions.assertEquals(1, um.getArraySize("DateArray"));
		Assertions.assertEquals(1, um.getDateArray("DateArray").length);
		Assertions.assertTrue(um.isArrayValue("DateArray"));
	}


	/**
	 * Bean->UniModel追加 Date Date配列 空
	 */
	@Test
	@DisplayName("Bean->UniModel追加 Date Date配列 空")
	public void addBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "Date");
		ModelUtil.addBeanItemValue(um, bean, "DateArray");

		Assertions.assertTrue(um.containsKey("Date"));
		Assertions.assertTrue(um.hasValue("Date"));
		Assertions.assertNull(um.getDate("Date"));
		Assertions.assertEquals(1, um.getArraySize("Date"));
		Assertions.assertEquals(1, um.getDateArray("Date").length);
		Assertions.assertFalse(um.isArrayValue("Date"));

		Assertions.assertTrue(um.containsKey("DateArray"));
		Assertions.assertTrue(um.hasValue("DateArray"));
		Assertions.assertNull(um.getDateArray("DateArray")[0]);
		Assertions.assertEquals(1, um.getArraySize("DateArray"));
		Assertions.assertEquals(1, um.getDateArray("DateArray").length);
		Assertions.assertTrue(um.isArrayValue("DateArray"));
	}

	/**
	 * Bean->UniModel追加 Date Date配列
	 */
	@Test
	@DisplayName("Bean->UniModel追加 Date Date配列")
	public void addBeanItemValueTest2() {
		final Date now = new Date();
		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "Date");
		ModelUtil.addBeanItemValue(um, bean, "DateArray");

		Assertions.assertTrue(um.containsKey("Date"));
		Assertions.assertTrue(um.hasValue("Date"));
		Assertions.assertEquals(now, um.getDate("Date"));
		Assertions.assertEquals(1, um.getArraySize("Date"));
		Assertions.assertEquals(1, um.getDateArray("Date").length);
		Assertions.assertFalse(um.isArrayValue("Date"));

		Assertions.assertTrue(um.containsKey("DateArray"));
		Assertions.assertTrue(um.hasValue("DateArray"));
		Assertions.assertEquals(now, um.getDateArray("DateArray")[0]);
		Assertions.assertEquals(1, um.getArraySize("DateArray"));
		Assertions.assertEquals(1, um.getDateArray("DateArray").length);
		Assertions.assertTrue(um.isArrayValue("DateArray"));
	}

	/**
	 * UniModel→Bean設定 空
	 */
	@Test
	@DisplayName("UniModel→Bean設定 空")
	public void setModelValueTest1() {
		final UniModelImpl um = new UniModelImpl();

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assertions.assertNull(bean.getDate());
		Assertions.assertNull(bean.getDateArray());
	}

	/**
	 * UniModel→Bean設定 Date Date配列
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Date Date配列")
	public void setModelValueTest2() {
		final Date now = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", now);
		um.setValue("DateArray", now);

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assertions.assertEquals(now, bean.getDate());
		Assertions.assertEquals(now, bean.getDateArray()[0]);
	}

	/**
	 * UniModel→Bean設定 DateからBoolean
	 */
	@Test
	@DisplayName("UniModel→Bean設定 DateからBoolean")
	public void setModelValueTest3() {
		final Date now1 = new Date();
		final Date now2 = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBooleanArray", now1, now2);
		um.setValue("BooleanArray", now1, now2);

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assertions.assertFalse(bean.isPrimitiveBooleanArray()[0]);
		Assertions.assertFalse(bean.isPrimitiveBooleanArray()[1]);
		Assertions.assertNull(bean.isBooleanArray()[0]);
		Assertions.assertNull(bean.isBooleanArray()[1]);
	}

	/**
	 * UniModel→Bean DateからInteger
	 */
	@Test
	@DisplayName("UniModel→Bean DateからInteger")
	public void setModelValueTest4() {
		final Date now1 = new Date();
		final Date now2 = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveIntegerArray", now1, now2);
		um.setValue("IntegerArray", now1, now2);

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um);

		Assertions.assertEquals(0, bean.getPrimitiveIntegerArray()[0]);
		Assertions.assertEquals(0, bean.getPrimitiveIntegerArray()[1]);
		Assertions.assertNull(bean.getIntegerArray()[0]);
		Assertions.assertNull(bean.getIntegerArray()[1]);
	}

	/**
	 * UniModel→Bean設定 Date null
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Date null")
	public void setModelValueTest5() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", (Date[])null);
		ModelUtil.setModelValue(bean, um);

		Assertions.assertNull(bean.getDate());
		Assertions.assertNotNull(bean.getDateArray());
		Assertions.assertEquals(0, bean.getDateArray().length);
	}

	/**
	 * UniModel→Bean設定 Date null 空配列
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Date null 空配列")
	public void setModelValueTest6() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", new Date[0]);
		ModelUtil.setModelValue(bean, um);

		Assertions.assertNull(bean.getDate());
		Assertions.assertNotNull(bean.getDateArray());
		Assertions.assertEquals(0, bean.getDateArray().length);
	}


	/**
	 * UniModel→Bean設定 Date 配列添字１
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Date 配列添字１")
	public void setModelValueTest10() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.getDate());
		Assertions.assertNull(bean.getDateArray());
	}

	/**
	 * UniModel→Bean設定 Date 配列添字１
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Date 配列添字１")
	public void setModelValueTest11() {
		final Date now = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", null, now);

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertEquals(now, bean.getDate());
	}

	/**
	 * UniModel→Bean設定 Date 配列添字１ Boolean
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Date 配列添字１ Boolean")
	public void setModelValueTest12() {
		final Date now1 = new Date();
		final Date now2 = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", now1, now2);
		um.setValue("Boolean", now1, now2);

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.isPrimitiveBooleanArray());
		Assertions.assertNull(bean.isBooleanArray());
		Assertions.assertFalse(bean.isPrimitiveBoolean());
		Assertions.assertNull(bean.isBoolean());
	}

	/**
	 * UniModel→Bean設定 Date 配列添字１ Integer
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Date 配列添字１ Integer")
	public void setModelValueTest13() {
		final Date now1 = new Date();
		final Date now2 = new Date();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", now1, now2);
		um.setValue("Integer", now1, now2);

		final JavaBean bean = new JavaBean();
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.getPrimitiveIntegerArray());
		Assertions.assertNull(bean.getIntegerArray());
		Assertions.assertEquals(0, bean.getPrimitiveInteger());
		Assertions.assertNull(bean.getInteger());
	}

	/**
	 * UniModel→Bean設定 Date 配列添字１
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Date 配列添字１")
	public void setModelValueTest15() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", (Date[])null);
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.getDate());
		Assertions.assertNotNull(bean.getDateArray());
		Assertions.assertEquals(0, bean.getDateArray().length);
	}

	/**
	 * UniModel→Bean設定 Date 配列添字１
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Date 配列添字１")
	public void setModelValueTest16() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.setValue("Date", (Date)null);
		um.setValue("DateArray", new Date[0]);
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.getDate());
		Assertions.assertNotNull(bean.getDateArray());
		Assertions.assertEquals(0, bean.getDateArray().length);
	}


	/**
	 * UniModel→Bean設定 Date
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Date")
	public void setModelValueTest20() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.noValue("Date");
		um.noValue("DateArray");
		ModelUtil.setModelValue(bean, um);

		Assertions.assertNull(bean.getDate());
		Assertions.assertNull(bean.getDateArray());
	}

	/**
	 * UniModel→Bean設定 Date
	 */
	@Test
	@DisplayName("niModel→Bean設定 Date")
	public void setModelValueTest21() {
		final Date now = new Date();

		final JavaBean bean = new JavaBean();
		bean.setDate(now);
		bean.setDateArray(new Date[]{now});

		final UniModelImpl um = new UniModelImpl();
		um.noValue("Date");
		um.noValue("DateArray");

		ModelUtil.setModelValue(bean, um, 0);

		Assertions.assertNull(bean.getDate());
		Assertions.assertNull(bean.getDateArray());

		bean.setDate(now);
		bean.setDateArray(new Date[]{now});
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.getDate());
		Assertions.assertNull(bean.getStringArray());
	}


	/**
	 * UniModel→Bean設定 Date
	 */
	@Test
	@DisplayName("UniModel→Bean設定 Date")
	public void setModelValueTest31() {
		final Date now1 = new Date();
		final Date now2 = new Date();

		final JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray("String");

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", now1, now2);
		um.setValue("StringArray", now2, now2);

		ModelUtil.setModelValue(bean, um, 2);

		Assertions.assertEquals("String", bean.getString());
		Assertions.assertNotNull(bean.getStringArray());
		Assertions.assertEquals(2, bean.getStringArray().length);
		Assertions.assertEquals(now1.toString(), bean.getStringArray()[0]);
		Assertions.assertEquals(now2.toString(), bean.getStringArray()[1]);
	}
}
