package online.model;

import java.io.Serializable;
import java.lang.reflect.Array;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

/**
 * TestUniMap
 *
 */
public class TestUniMap {

	/**
	 * testArraySize1
	 */
	@Test
	public void testArraySize1() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null, String.class);
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertFalse(um.isArrayValue("aaaaa"));
		Assertions.assertEquals("{aaaaa=null}", um.toString());
		Assertions.assertNull(um.get("aaaaa"));
	}

	/**
	 * testArraySize2
	 */
	@Test
	public void testArraySize2() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null, String[].class);
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals("{aaaaa=null}", um.toString());
		Assertions.assertNull(um.get("aaaaa"));
	}

	/**
	 * testArraySize3
	 */
	@Test
	public void testArraySize3() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[]{null});
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals("{aaaaa=[null]}", um.toString());
		Assertions.assertNull(Array.get(um.get("aaaaa"), 0));
	}

	/**
	 * testArraySize4
	 */
	@Test
	public void testArraySize4() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[][]{new String[]{null}});
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals("{aaaaa=[[null]]}", um.toString());
		Assertions.assertNull(Array.get(Array.get(um.get("aaaaa"), 0), 0));
	}

	/**
	 * testArraySize5
	 */
	@Test
	public void testArraySize5() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[0]);
		Assertions.assertEquals(0, um.getArraySize("aaaaa"));
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals("{aaaaa=[]}", um.toString());
		Assertions.assertEquals(0, Array.getLength(um.get("aaaaa")));
	}

	/**
	 * testArraySize6
	 */
	@Test
	public void testArraySize6() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[0][0]);
		Assertions.assertEquals(0, um.getArraySize("aaaaa"));
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals("{aaaaa=[[]]}", um.toString());
		Assertions.assertEquals(String[][].class, um.get("aaaaa").getClass());
	}

	/**
	 * testArraySize7
	 */
	@Test
	public void testArraySize7() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.putRaw("aaaaa", new String[0]);
		Assertions.assertEquals(0, um.getArraySize("aaaaa"));
		Assertions.assertFalse(um.isArrayValue("aaaaa"));
		Assertions.assertEquals("{aaaaa=null}", um.toString());
		Assertions.assertNull(um.get("aaaaa"));
	}

	/**
	 * testArraySize8
	 */
	@Test
	public void testArraySize8() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.putRaw("aaaaa", new String[0][0]);
		Assertions.assertEquals(0, um.getArraySize("aaaaa"));
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals("{aaaaa=null}", um.toString());
		Assertions.assertNull(um.get("aaaaa"));
	}

	/**
	 * testArraySize9
	 */
	@Test
	public void testArraySize9() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.putRaw("aaaaa", new String[1][0]);
		Assertions.assertEquals(0, um.getArraySize("aaaaa"));
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals("{aaaaa=[]}", um.toString());
		Assertions.assertEquals(0, Array.getLength(um.get("aaaaa")));
	}


	/**
	 * testToArray1
	 */
	@Test
	public void testToArray1() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null);
		Assertions.assertFalse(um.isArrayValue("aaaaa"));
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));

		Assertions.assertTrue(um.toArrayValue("aaaaa"));

		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
	}

	/**
	 * testToArray2
	 */
	@Test
	public void testToArray2() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", null, String[].class);
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));

		Assertions.assertFalse(um.toArrayValue("aaaaa"));

		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals(1, um.getArraySize("aaaaa"));
	}

	/**
	 * testToArray3
	 */
	@Test
	public void testToArray3() {
		final UniMap<String, Serializable> um = new UniMap<>();
		um.put("aaaaa", new String[]{null, null});
		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals(2, um.getArraySize("aaaaa"));

		Assertions.assertFalse(um.toArrayValue("aaaaa"));

		Assertions.assertTrue(um.isArrayValue("aaaaa"));
		Assertions.assertEquals(2, um.getArraySize("aaaaa"));
	}

}
