package project.common;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * TestStringUtil
 *
 */
public class TestStringUtil {

	/**
	 * 先頭ゼロサプレス
	 */
	@Test
	@DisplayName("先頭ゼロサプレス")
	public void suppressZeroTest1() {
		Assertions.assertEquals("1", StringUtil.suppressZero("0001"));
	}

	/**
	 * 先頭ゼロサプレス小数点あり
	 */
	@Test
	@DisplayName("先頭ゼロサプレス小数点あり")
	public void suppressZeroTest2() {
		Assertions.assertEquals("1.123", StringUtil.suppressZero("0001.123"));
	}


	/**
	 * 左トリム
	 */
	@Test
	@DisplayName("左トリム")
	public void trimLeftTest1() {
		Assertions.assertEquals("1", StringUtil.trimLeft("0001", '0'));
	}


	/**
	 * 右トリム
	 */
	@Test
	@DisplayName("右トリム")
	public void trimRightTest1() {
		Assertions.assertEquals("000", StringUtil.trimRight("0001", '1'));
	}


	/**
	 * 指定文字列挿入空文字
	 */
	@Test
	@DisplayName("指定文字列挿入空文字")
	public void infixTest1() {
		Assertions.assertEquals("", StringUtil.infix("", "-", 1, 2));
	}

	/**
	 * 指定文字列挿入一文字
	 */
	@Test
	@DisplayName("指定文字列挿入一文字")
	public void infixTest2() {
		Assertions.assertEquals("A", StringUtil.infix("A", "-", 1, 2));
	}

	/**
	 * 指定文字列挿入２文字
	 */
	@Test
	@DisplayName("指定文字列挿入２文字")
	public void infixTest3() {
		Assertions.assertEquals("A-B", StringUtil.infix("AB", "-", 1));
	}

	/**
	 * 指定文字列挿入２文字右から
	 */
	@Test
	@DisplayName("指定文字列挿入２文字右から")
	public void infixTest4() {
		Assertions.assertEquals("A-B", StringUtil.infix("AB", "-", -1));
	}

	/**
	 * 指定文字列挿入７文字左右から７以下指定
	 */
	@Test
	@DisplayName("指定文字列挿入７文字左右から７以下指定")
	public void infixTest5() {
		Assertions.assertEquals("AB-C-D-EF-G", StringUtil.infix("ABCDEFG", "-", -1, 2, 3, -3));
	}

	/**
	 * 指定文字列挿入７文字左右から７以上指定あり時
	 */
	@Test
	@DisplayName("指定文字列挿入７文字左右から７以上指定あり時")
	public void infixTest6() {
		Assertions.assertEquals("AB-CDEF-G", StringUtil.infix("ABCDEFG", "-", -1, 2, 13, -9));
	}

	/**
	 * 連番配列取得1
	 */
	@Test
	@DisplayName("連番配列取得1")
	public void sequenceTest1() {
		final String[] actual = StringUtil.sequence(3, 2);
		Assertions.assertEquals("2", actual[0]);
		Assertions.assertEquals("3", actual[1]);
		Assertions.assertEquals("4", actual[2]);
	}

	/**
	 * 数値としてソート1
	 */
	@Test
	@DisplayName("数値としてソート1")
	public void sortAsNumericTest1() {
		final String[] actual = StringUtil.sortAsNumeric("1", "11", "12", "2", "21");
		Assertions.assertEquals("1", actual[0]);
		Assertions.assertEquals("2", actual[1]);
		Assertions.assertEquals("11", actual[2]);
		Assertions.assertEquals("12", actual[3]);
		Assertions.assertEquals("21", actual[4]);
	}
}
