/*
 * Copyright 2004-2014 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.extension.jta;

import javax.transaction.Status;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * @author higa
 *
 */
public class TransactionManagerImplTest {

    /** target */
    private TransactionManager tm = null;

    /**
     * setUp
     */
    @Before
    public void setUp() {
        this.tm = new TransactionManagerImpl();
    }

    /**
     * @throws Exception Exception
     */
    @Test
    public void testResume() throws Exception {
        this.tm.begin();
        final Transaction tx = this.tm.suspend();
        this.tm.begin();
        this.tm.commit();
        this.tm.resume(tx);
        this.tm.commit();
    }

    /**
     * testCommit
     * @throws Exception Exception
     */
    @Test
    public void testCommit() throws Exception {
        this.tm.begin();
        this.tm.commit();
        Assert.assertEquals("1", Status.STATUS_NO_TRANSACTION, this.tm.getStatus());
    }

    /**
     * testRollback
     * @throws Exception Exception
     */
    @Test
    public void testRollback() throws Exception {
        this.tm.begin();
        this.tm.rollback();
        Assert.assertEquals("1", Status.STATUS_NO_TRANSACTION, this.tm.getStatus());
    }
}
