package common.db.dao.hibernate;

import java.util.Optional;

import org.hibernate.dialect.Dialect;

/**
 * JDBC実行
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public abstract class HibernateJdbcWork {

	/** ダイアレクト */
	private Dialect dialect = null;

	/**
	 * ダイアレクト設定
	 *
	 * @param val ダイアレクト
	 */
	public void setDialect(final Dialect val) {
		this.dialect = val;
	}

	/**
	 * シーケンスSQL取得
	 *
	 * @param name シーケンス名
	 * @return シーケンスSQL
	 */
	protected String getSequenceNextValString(final String name) {
		return Optional.ofNullable(this.dialect).
				map(d -> d.getSequenceNextValString(name)).orElse(null);
	}
}
